package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissibleBase;

public class PermissionVariable implements Variable<Boolean[]>
{
	protected static final String UUID_CODE = "uuid";
	
	Variable<UUID> playerUUID;
	String[] permissions;

	public PermissionVariable(Variable<UUID> playerUUID, String... permissions)
	{
		this.playerUUID = playerUUID;
		this.permissions = permissions;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		playerUUID = (Variable<UUID>) Warmonger.Read(input);
		
		int length = input.readInt();
		
		permissions = new String[length];
		
		for(int i = 0; i < length; i++)
		{
			permissions[i] = input.readUTF();
		}
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(playerUUID, output);
		
		output.writeInt(permissions.length);
		
		for(int i = 0; i < permissions.length; i++)
		{
			output.writeUTF(permissions[i]);
		}
	}

	@Override
	public Boolean[] GetValue(final Map<String, Object> params)
	{
		Player player = GetPlayer(params);
		Boolean[] result = new Boolean[permissions.length];

		for (int i = 0; i < permissions.length; i++)
		{
			result[i] = player.hasPermission(permissions[i]);
		}

		return result;
	}

	public boolean DoesMatch(final Map<String, Object> params, Boolean[] value)
	{
		Player player = GetPlayer(params);

		for (int i = 0; i < permissions.length; i++)
		{
			if (player.hasPermission(permissions[i]) != value[i]) { return false; }
		}

		return true;
	}
	
	public boolean DoesMatch(final Map<String, Object> params, Variable<Boolean[]> value)
	{
		Player player = GetPlayer(params);
		Boolean[] booleans = value.GetValue(params);

		for (int i = 0; i < permissions.length && i < booleans.length; i++)
		{
			if (player.hasPermission(permissions[i]) != booleans[i]) { return false; }
		}

		return true;
	}
	
	public boolean DoesObjectMatch(final Map<String, Object> params, PermissibleBase object)
	{
		for (String s : permissions)
		{
			if (object.hasPermission(s)) { return false; }
		}

		return true;
	}
	
	protected Player GetPlayer(Map<String, Object> params)
	{
		return Bukkit.getPlayer(playerUUID.GetValue(params));
	}
}
