package an0nym8us.warmonger;

import org.bukkit.enchantments.Enchantment;

public class PatternProvider
{
	static class Wrapper<T>
	{
		T value;
		Optionality optionality;
		
		public Wrapper(T value, Optionality optionality)
		{
			this.value = value;
			this.optionality = optionality;
		}
		
		public T GetValue()
		{
			return value;
		}
		
		public Optionality GetOptionality()
		{
			return optionality;
		}
	}
	
	public static class EnchantmentWrapper extends Wrapper<NBTTagCompoundValue>
	{
		public EnchantmentWrapper(Enchantment ench, int level, Optionality optionality)
		{
			super(Convert(ench, level, -1, optionality), optionality);
		}
		
		public EnchantmentWrapper(Enchantment ench, int minLevel, int maxLevel, Optionality optionality)
		{
			super(Convert(ench, minLevel, maxLevel, optionality), optionality);
		}
		
		protected static NBTTagCompoundValue Convert(Enchantment ench, int minLevel, int maxLevel, Optionality optionality)
		{
			NBTPrimitiveValue<?>[] ar = new NBTPrimitiveValue<?>[2];
			ar[0] = new NBTPrimitiveValue<Short>("id", new Constant<Short>((short)ench.getId()));
			ar[1] = maxLevel < 0 ? new NBTPrimitiveValue<Short>("lvl", new Constant<Short>((short) minLevel)) : new NBTPrimitiveValue<Number>("lvl", new NumberVariable(minLevel, maxLevel));
			
			return new NBTTagCompoundValue("", ar);
		}
	}
	
	public static NBTVariable<String> Name(String name)
	{
		return new NBTPrimitiveValue<String>("tag.display.Name", name).GetNBTValue();
	}
	
	public static NBTArrayValue<String> Lore(Wrapper<String>... lore)
	{
		Constant<String>[] ar = new Constant[lore.length];
		
		for(int i = 0; i < lore.length; i++)
		{
			ar[i] = new Constant<String>(lore[i].GetValue());
		}
		
		return new NBTArrayValue<String>("tag.display.Lore", ar);
	}
	
	public static NBTListValue Enchantments(EnchantmentWrapper... enchs)
	{
		NBTTagCompoundValue[] ar = new NBTTagCompoundValue[enchs.length];
		
		for(int i = 0; i < enchs.length; i++)
		{
			ar[i] = (NBTTagCompoundValue)enchs[i].GetValue();
		}
		
		return new NBTListValue("tag.ench", ar);
	}
	
	public static NBTPrimitiveValue<Number> Count(int count)
	{
		return new NBTPrimitiveValue<Number>("Count", count);
	}
}
