package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Random;

import javax.annotation.Nullable;

public class NumberVariable<T extends Number> implements Variable<T>
{
	public static final Random randomGenerator = new Random();
	
	Variable<Number> bottomBorder;
	@Nullable Variable<Number> topBorder;

	public NumberVariable(Number val)
	{
		this(val.doubleValue());
	}

	public NumberVariable(double val)
	{
		this.bottomBorder = new Constant<Number>(val);
		this.topBorder = null;
	}
	
	public NumberVariable(Variable<Number> val)
	{
		this.bottomBorder = val;
		this.topBorder = null;
	}

	public NumberVariable(Number bottomBorder, Number topBorder)
	{
		this(bottomBorder.doubleValue(), topBorder.doubleValue());
	}

	public NumberVariable(double bottomBorder, double topBorder)
	{
		this.bottomBorder = new Constant<Number>(bottomBorder);
		this.topBorder = new Constant<Number>(topBorder);
	}
	
	public NumberVariable(Variable<Number> bottomBorder, Variable<Number> topBorder)
	{
		this.bottomBorder = bottomBorder;
		this.topBorder =topBorder;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		bottomBorder = (Variable<Number>) Warmonger.Read(input);
		topBorder = input.readBoolean() ? (Variable<Number>)Warmonger.Read(input) : null;
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(bottomBorder, output);
		
		if(topBorder == null)
		{
			output.writeBoolean(false);
		}
		else
		{
			output.writeBoolean(true);
			
			Warmonger.Write(topBorder, output);
		}
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		if(topBorder == null)
		{
			return (T) bottomBorder.GetValue(params);
		}
		
		
		
		return (T)(Double)(((randomGenerator.nextDouble() *  (topBorder.GetValue(params).doubleValue() - bottomBorder.GetValue(params).doubleValue())) + bottomBorder.GetValue(params).doubleValue()));
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		double doubleRes = ((Number) value).doubleValue();

		return topBorder == null ? (doubleRes == bottomBorder.GetValue(params).doubleValue()) : (doubleRes >= bottomBorder.GetValue(params).doubleValue() && doubleRes <= topBorder.GetValue(params).doubleValue());
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, Variable<T> value)
	{
		return DoesMatch(params, value.GetValue(params));
	}
}
