package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import org.bukkit.inventory.ItemStack;

public class NBTVariable<T> implements Variable<T>, ISettable<T>, IDeleteable<T>
{
	Variable<Object> nbtTagCompound;
	Variable<NBTAbstractValue<T>> value;
	
	public NBTVariable(Variable<Object> nbtTagCompound, NBTAbstractValue<T> value)
	{
		this(nbtTagCompound, new Constant<NBTAbstractValue<T>>(value));
	}
	
	public NBTVariable(Variable<Object> nbtTagCompound, Variable<NBTAbstractValue<T>> value)
	{
		this.nbtTagCompound = nbtTagCompound;
		this.value = value;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		nbtTagCompound = (Variable<Object>) Warmonger.Read(input);
		
		value = (Variable<NBTAbstractValue<T>>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(nbtTagCompound, output);
		
		Warmonger.Write(value, output);
	}

	public boolean DeleteValue(Map<String, Object> params)
	{
		return value.GetValue(params).DeleteValue(nbtTagCompound.GetValue(params));
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		return this.value.GetValue(params).SetValue(nbtTagCompound.GetValue(params), value);
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		return value.GetValue(params).GetValue(nbtTagCompound.GetValue(params));
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return this.value.GetValue(params).GetValue(nbtTagCompound).equals(value);
	}
	
	@Override
	public boolean DoesMatch(final Map<String, Object> params, Variable<T> value)
	{
		return value.DoesMatch(params, this.value.GetValue(params).GetValue(nbtTagCompound.GetValue(params)));
	}
	
	public boolean DoesItemMatch(ItemStack itemStack, Map<String, Object> params)
	{
		Object nbtBase = value.GetValue(params).GetNBTBase(itemStack);

		return value.GetValue(params).DoesMatch(nbtBase, params);
	}
}
