package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Map.Entry;

public class NBTTagCompoundValue extends NBTAbstractValue<Object>
{
	NBTAbstractValue<?>[] values;

	NBTTagCompoundValue(String path)
	{
		super(path);
	}

	public NBTTagCompoundValue(String path, NBTAbstractValue<?>... values)
	{
		super(path);

		this.values = values;
	}

	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();

		if (path == null || path.isEmpty())
		{
			sb.append('{');
		}
		else
		{
			sb.append(path);
			sb.append(":{");
		}

		for (int i = 0; i < values.length - 1; i++)
		{
			sb.append(values[i].toString());
			sb.append(',');
		}

		sb.append(values[values.length - 1].toString());

		sb.append('}');

		return sb.toString();
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		values = new NBTAbstractValue<?>[input.readInt()];

		for (int i = 0; i < values.length; i++)
		{
			values[i] = (NBTAbstractValue<?>) Warmonger.Read(input);
		}
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(values.length);

		for (int i = 0; i < values.length; i++)
		{
			Warmonger.Write(values[i], output);
		}
	}

	@Override
	public boolean DoesMatch(Object nbtBase, Map<String, Object> params)
	{
		nbtBase = GetNBTBase(nbtBase);

		Map<String, Object> map = GetMap(nbtBase);

		for (NBTAbstractValue value : values)
		{
			if (!value.DoesMatch(nbtBase, params)) { return false; }
		}

		return true;
	}

	protected Map<String, Object> GetMap(Map<String, Object> params)
	{
		return GetMap(GetValue(params));
	}

	protected Map<String, Object> GetMap(Object nbtTagCompound)
	{
		Map<String, Object> res = null;

		Field field;

		try
		{
			field = nbtTagCompound.getClass().getDeclaredField("map");
			field.setAccessible(true);

			res = (Map<String, Object>) field.get(nbtTagCompound);
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}

		return res;
	}

	@Override
	public Object PrepareNBTBase(Object nbtBase, Map<String, Object> params)
	{
		nbtBase = DigNBTBase(nbtBase, path);

		for (NBTAbstractValue<?> var : values)
		{
			var.PrepareNBTBase(nbtBase, params);
		}

		return nbtBase;
	}

	@Override
	protected void LoadNBTBase(Object nbtTagCompound)
	{
		Field field;

		try
		{
			nbtTagCompound = GetNBTBase(nbtTagCompound);
			field = nbtTagCompound.getClass().getDeclaredField("map");
			field.setAccessible(true);

			Map<String, Object> map = (Map<String, Object>) field.get(nbtTagCompound);

			values = new NBTAbstractValue[map.size()];

			int i = 0;
			for (Entry<String, Object> entry : map.entrySet())
			{
				values[i] = CreateVariable(entry.getKey(), entry.getValue().getClass());

				values[i].LoadNBTBase(nbtTagCompound);

				i++;
			}
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}
	}
}
