package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class NBTPrimitiveValue<T> extends NBTAbstractValue<T>
{
	Variable<T> primValue;

	NBTPrimitiveValue(String path)
	{
		super(path);
	}

	public NBTPrimitiveValue(String path, T primValue)
	{
		super(path);

		this.primValue = new Constant<T>(primValue);
	}

	public NBTPrimitiveValue(String path, Variable<T> primValue)
	{
		super(path);

		this.primValue = primValue;
	}
	
	@Override
	public String toString()
	{
		return path == null ? "val" : path + ":val";
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		primValue = (Variable<T>) Warmonger.Read(input);
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(primValue, output);
	}

	@Override
	public boolean DoesMatch(Object nbtBase, Map<String, Object> params)
	{
		return primValue.DoesMatch(params, GetValue(nbtBase));
	}

	@Override
	public Object PrepareNBTBase(Object nbtBase, Map<String, Object> params)
	{
		nbtBase = DigNBTBase(nbtBase, GetPath(), 1);

		try
		{
			Field field = _nbtTagCompound.getDeclaredField("map");
			field.setAccessible(true);

			Map<String, Object> map = (Map<String, Object>) field.get(nbtBase);

			T value = primValue.GetValue(params);

			Constructor<?> c;

			if (value instanceof Byte)
			{
				c = _nbtTagByte.getDeclaredConstructor();
			}
			else if (value instanceof Double)
			{
				c = _nbtTagDouble.getDeclaredConstructor();
			}
			else if (value instanceof Float)
			{
				c = _nbtTagFloat.getDeclaredConstructor();
			}
			else if (value instanceof Integer)
			{
				c = _nbtTagInt.getDeclaredConstructor();
			}
			else if (value instanceof Long)
			{
				c = _nbtTagLong.getDeclaredConstructor();
			}
			else if (value instanceof Short)
			{
				c = _nbtTagShort.getDeclaredConstructor();
			}
			else if (value instanceof String)
			{
				c = _nbtTagString.getDeclaredConstructor();
			}
			else
			{
				throw new IllegalArgumentException("Illegal type of NBTPrimitive.");
			}

			c.setAccessible(true);

			nbtBase = c.newInstance();

			String[] path = GetPath().split("\\.");

			map.put(path[path.length - 1], nbtBase);

			SetValueDirectly(nbtBase, value);
		}
		catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException
				| InstantiationException | NoSuchMethodException | InvocationTargetException e)
		{
			e.printStackTrace();

			return null;
		}

		return nbtBase;
	}

	@Override
	protected void LoadNBTBase(Object nbtBase)
	{
		Field field;

		try
		{
			nbtBase = GetNBTBase(nbtBase);
			
			field = nbtBase.getClass().getDeclaredField("data");
			field.setAccessible(true);
			
			primValue = new Constant<T>((T) field.get(nbtBase));
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}
	}
}
