package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class NBTListValue extends NBTAbstractValue<List<Object>>
{
	NBTAbstractValue<?>[] values;

	NBTListValue(String path)
	{
		super(path);
	}

	public NBTListValue(String path, NBTTagCompoundValue... values)
	{
		super(path);

		this.values = values;
	}
	
	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		
		if (path == null || path.isEmpty())
		{
			sb.append('[');
		}
		else
		{
			sb.append(path);
			sb.append(":[");
		}
		
		for(int i = 0; i < values.length - 1; i++)
		{
			sb.append(values[i].toString());
			sb.append(',');
		}
		
		sb.append(values[values.length - 1].toString());
		
		sb.append(']');
		
		return sb.toString();
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		values = new NBTAbstractValue[input.readInt()];

		for (int i = 0; i < values.length; i++)
		{
			values[i] = (NBTAbstractValue<?>) Warmonger.Read(input);
		}
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(values.length);

		for (int i = 0; i < values.length; i++)
		{
			Warmonger.Write(values[i], output);
		}
	}

	public List<Object> GetValue(Object nbtBase)
	{
		nbtBase = GetNBTBase(nbtBase);

		List<Object> res = null;

		Field field;

		try
		{
			field = nbtBase.getClass().getDeclaredField("list");
			field.setAccessible(true);

			res = (List<Object>) field.get(nbtBase);
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}

		return res;
	}

	@Override
	public boolean DoesMatch(Object nbtBase, Map<String, Object> params)
	{
		List<Object> list = GetValue(nbtBase);

		for (Object value : list)
		{
			boolean matchFound = false;

			for (NBTAbstractValue<?> value1 : values)
			{
				if (value1.DoesMatch(value, params))
				{
					matchFound = true;

					break;
				}
			}

			if (!matchFound) { return false; }
		}

		return true;
	}

	@Override
	public Object PrepareNBTBase(Object nbtBase, Map<String, Object> params)
	{
		nbtBase = DigNBTBase(nbtBase, GetPath(), 1);

		try
		{
			Field field = _nbtTagCompound.getDeclaredField("map");
			field.setAccessible(true);

			Map<String, Object> map = (Map<String, Object>) field.get(nbtBase);

			nbtBase = NewNBTList();

			String[] path = GetPath().split("\\.");

			map.put(path[path.length - 1], nbtBase);

			field = _nbtTagList.getDeclaredField("list");
			field.setAccessible(true);

			List<Object> list = (List<Object>) field.get(nbtBase);

			for (NBTAbstractValue<?> var : values)
			{
				list.add(var.PrepareNBTBase(params));
			}
		}
		catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException
				| InstantiationException e)
		{
			e.printStackTrace();

			return null;
		}

		return nbtBase;
	}

	private static Object NewNBTList()
			throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException
	{
		Object res = _nbtTagList.newInstance();

		Field field = _nbtTagList.getDeclaredField("type");
		field.setAccessible(true);

		field.set(res, (byte) 10);

		return res;
	}

	@Override
	protected void LoadNBTBase(Object nbtBase)
	{
		Field field;

		try
		{
			nbtBase = GetNBTBase(nbtBase);
			
			field = nbtBase.getClass().getDeclaredField("list");
			field.setAccessible(true);

			List<Object> list = (List<Object>) field.get(nbtBase);
			
			values = new NBTAbstractValue[list.size()];
			
			for(int i = 0; i < values.length; i++)
			{
				Object obj = list.get(i);
				
				values[i] = CreateVariable(null, obj.getClass());
				
				values[i].LoadNBTBase(obj);
				
				i++;
			}
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}
	}
}
