package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class NBTArrayValue<T> extends NBTAbstractValue<T[]>
{
	Variable<T>[] values;

	NBTArrayValue(String path)
	{
		super(path);
	}

	public NBTArrayValue(String path, Variable<T>[] values)
	{
		super(path);

		this.values = values;
	}
	
	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder();
		
		if (path == null || path.isEmpty())
		{
			sb.append('{');
		}
		else
		{
			sb.append(path);
			sb.append(":{");
		}
		
		for(int i = 0; i < values.length - 1; i++)
		{
			sb.append("val");
			sb.append(',');
		}
		
		sb.append(values[values.length - 1].toString());
		
		sb.append('}');
		
		return sb.toString();
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		values = new Variable[input.readInt()];

		for (int i = 0; i < values.length; i++)
		{
			values[i] = (Variable<T>) Warmonger.Read(input);
		}
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(values.length);

		for (int i = 0; i < values.length; i++)
		{
			Warmonger.Write(values[i], output);
		}
	}

	@Override
	public boolean DoesMatch(Object nbtBase, Map<String, Object> params)
	{
		T[] array = GetValue(nbtBase);

		for (Variable value : values)
		{
			boolean matchFound = false;

			for (T value1 : array)
			{
				if (value.DoesMatch(params, value1))
				{
					matchFound = true;

					break;
				}
			}

			if (!matchFound) { return false; }
		}

		return true;
	}

	@Override
	public Object PrepareNBTBase(Object nbtBase, Map<String, Object> params)
	{
		nbtBase = DigNBTBase(nbtBase, GetPath(), 1);

		try
		{
			Field field = _nbtTagCompound.getDeclaredField("map");
			field.setAccessible(true);

			Map<String, Object> map = (Map<String, Object>) field.get(nbtBase);

			Constructor<?> c;

			{
				Object testObj = values[0].GetValue(params);

				if (testObj instanceof Integer)
				{
					c = _nbtTagIntArray.getDeclaredConstructor();
				}
				else if (testObj instanceof Byte)
				{
					c = _nbtTagByteArray.getDeclaredConstructor();
				}
				else
				{
					throw new IllegalArgumentException("Illegal type of NBTArray.");
				}
			}

			c.setAccessible(true);

			nbtBase = c.newInstance();

			String[] path = GetPath().split("\\.");

			map.put(path[path.length - 1], nbtBase);
		}
		catch (NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException
				| InstantiationException | InvocationTargetException | NoSuchMethodException e)
		{
			e.printStackTrace();

			return null;
		}

		T[] ar = (T[]) new Object[values.length];

		SetValueDirectly(nbtBase, ar);

		return nbtBase;
	}

	@Override
	protected void LoadNBTBase(Object nbtBase)
	{
		Field field;

		try
		{
			nbtBase = GetNBTBase(nbtBase);

			field = nbtBase.getClass().getDeclaredField("data");
			field.setAccessible(true);

			T[] ar = (T[]) field.get(nbtBase);

			values = new Variable[ar.length];

			for (int i = 0; i < ar.length; i++)
			{
				values[i] = new Constant<T>(ar[i]);
			}
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		} // TODO Auto-generated method stub

	}
}
