package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.annotation.Nullable;

import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.NMSProvider;

public abstract class NBTAbstractValue<T> implements Unit
{
	protected static Class<?> _nbtBase;
	protected static Class<?> _nbtTagCompound;
	protected static Class<?> _nbtTagList;
	protected static Class<?> _nbtTagIntArray;
	protected static Class<?> _nbtTagByteArray;
	protected static Class<?> _nbtTagByte;
	protected static Class<?> _nbtTagDouble;
	protected static Class<?> _nbtTagFloat;
	protected static Class<?> _nbtTagInt;
	protected static Class<?> _nbtTagLong;
	protected static Class<?> _nbtTagShort;
	protected static Class<?> _nbtTagString;
	protected static Class<?> _itemStack;
	protected static Class<?> _craftItemStack;

	protected static Method _nTC_get;
	protected static Method _nTC_getCompound;
	protected static Method _nTC_hasKey;
	protected static Method _cIS_asNMSCopy;
	protected static Method _cIS_asBukkitCopy;
	protected static Method _iS_getTag;
	protected static Method _iS_save;
	protected static Method _iS_createStack;

	static
	{
		try
		{
			_nbtBase = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTBase");
			_nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagCompound");
			_nbtTagList = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagList");
			_nbtTagIntArray = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagIntArray");
			_nbtTagByteArray = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagByteArray");
			_nbtTagByte = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagByte");
			_nbtTagDouble = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagDouble");
			_nbtTagFloat = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagFloat");
			_nbtTagInt = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagInt");
			_nbtTagLong = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagLong");
			_nbtTagShort = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagShort");
			_nbtTagString = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagString");
			_itemStack = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".ItemStack");
			_craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + NMSProvider.GetNMSVersion() + ".inventory.CraftItemStack");

			_nTC_get = NMSProvider.GetMethod(_nbtTagCompound, "get", String.class);
			_nTC_getCompound = NMSProvider.GetMethod(_nbtTagCompound, "getCompound", String.class);
			_nTC_hasKey = NMSProvider.GetMethod(_nbtTagCompound, "hasKey", String.class);
			_cIS_asNMSCopy = NMSProvider.GetMethod(_craftItemStack, "asNMSCopy", ItemStack.class);
			_cIS_asBukkitCopy = NMSProvider.GetMethod(_craftItemStack, "asBukkitCopy", _itemStack);
			_iS_getTag = NMSProvider.GetMethod(_itemStack, "getTag");
			_iS_save = NMSProvider.GetMethod(_itemStack, "save", _nbtTagCompound);
			_iS_createStack = NMSProvider.GetMethod(_itemStack, "createStack", _nbtTagCompound);
		}
		catch (ClassNotFoundException | NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
		}
	}

	private static final Map<String, Class<? extends NBTAbstractValue<?>>> types = new HashMap<String, Class<? extends NBTAbstractValue<?>>>();

	String path;

	public NBTAbstractValue(String path)
	{
		this.path = path;
	}

	public static void Save(Object nbtBase, OutputStream output)
	{
		try
		{
			Method _nCST_a_o = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTCompressedStreamTools")
					.getDeclaredMethod("a", _nbtTagCompound, OutputStream.class);

			_nCST_a_o.invoke(null, nbtBase, output);
		}
		catch (NoSuchMethodException | SecurityException | ClassNotFoundException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static String GetID(Class<? extends NBTAbstractValue<?>> clazz)
	{
		for (Entry<String, Class<? extends NBTAbstractValue<?>>> entry : types.entrySet())
		{
			if (entry.getValue() == clazz) { return entry.getKey(); }
		}

		return null;
	}

	public static Class<? extends NBTAbstractValue<?>> GetClass(String ID)
	{
		return types.get(ID);
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeUTF(path);
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		path = input.readUTF();
	}

	public String GetPath()
	{
		return path;
	}

	public T GetValue(Object nbtBase)
	{
		nbtBase = GetNBTBase(nbtBase);

		T res = null;

		Field field;

		try
		{
			field = nbtBase.getClass().getDeclaredField("data");
			field.setAccessible(true);

			res = (T) field.get(nbtBase);
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}

		return res;
	}

	public boolean DeleteValue(Object nbtTagCompound)
	{
		Object nbtBase = GetNBTBase(nbtTagCompound, GetPath(), 1);

		if (!nbtBase.getClass().isAssignableFrom(_nbtTagCompound)) { return false; }

		Field field;

		try
		{
			field = nbtBase.getClass().getDeclaredField("map");
			field.setAccessible(true);

			Map<String, ?> map = (Map<String, ?>) field.get(nbtBase);

			String[] p = path.split("\\.");
			map.remove(p[p.length - 1]);

			field.set(nbtBase, map);

			return true;
		}
		catch (SecurityException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (NoSuchFieldException | IllegalArgumentException | ClassCastException e)
		{

		}

		return false;
	}

	public boolean SetValue(Object nbtBase0, T value)
	{
		return SetValue(nbtBase0, GetPath(), value);
	}

	public boolean SetValueDirectly(Object nbtBase0, T value)
	{
		return SetValue(nbtBase0, "", value);
	}

	public boolean SetValue(Object nbtBase0, String path, T value)
	{
		try
		{
			Object nbtBase1 = GetNBTBase(nbtBase0, path);

			Field field = nbtBase1.getClass().getDeclaredField("data");
			field.setAccessible(true);
			field.set(nbtBase1, value);

			return true;
		}
		catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e)
		{
			e.printStackTrace();
		}

		return false;
	}

	public abstract boolean DoesMatch(Object nbtBase, Map<String, Object> params);

	public boolean DoesMatch(ItemStack itemStack, Map<String, Object> params)
	{
		return DoesMatch(GetNBTBase(itemStack), params);
	}

	@Nullable
	public final Object GetNBTBase(Object nbtTagCompound)
	{
		return GetNBTBase(nbtTagCompound, GetPath(), 0);
	}

	@Nullable
	public static final Object GetNBTBase(Object nbtTagCompound, String path)
	{
		return GetNBTBase(nbtTagCompound, path, 0);
	}

	@Nullable
	public static Object GetNBTBase(Object nbtTagCompound, String path, int backIndex)
	{
		try
		{
			if (path == null || path.isEmpty())
			{
				return nbtTagCompound;
			}
			else
			{
				String[] pathAr = path.split("\\.");

				for (int i = 0; i < pathAr.length - 1 - backIndex; i++)
				{
					if (!(boolean) _nTC_hasKey.invoke(nbtTagCompound, pathAr[i])
							|| nbtTagCompound == null) { return null; }

					nbtTagCompound = _nTC_getCompound.invoke(nbtTagCompound, pathAr[i]);
				}

				return pathAr.length - backIndex < 1 ? nbtTagCompound
						: _nTC_get.invoke(nbtTagCompound, pathAr[pathAr.length - 1 - backIndex]);
			}
		}
		catch (IllegalAccessException | InvocationTargetException | SecurityException ex)
		{
			ex.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	public final Object GetNBTBase(ItemStack itemStack)
	{
		return GetNBTBase(itemStack, "");
	}

	public final Object GetNBTBase(ItemStack itemStack, String path)
	{
		return GetNBTBase(itemStack, path, 0);
	}

	public final Object GetNBTBase(ItemStack itemStack, String path, int backIndex)
	{
		try
		{
			Object _itemStackCIS = _cIS_asNMSCopy.invoke(null, itemStack);

			Object nbtTagCompound = _nbtTagCompound.newInstance();

			return GetNBTBase(_iS_save.invoke(_itemStackCIS, nbtTagCompound), path, backIndex);
		}
		catch (IllegalAccessException | InvocationTargetException | SecurityException | InstantiationException ex)
		{
			ex.printStackTrace();
		}

		return false;
	}

	public NBTVariable<T> GetNBTValue()
	{
		return new NBTVariable<T>(new LocalVariable<Object>("nbt"), this);
	}

	public NBTVariable<T> GetNBTValue(String param)
	{
		return new NBTVariable<T>(new LocalVariable<Object>(param), this);
	}

	public Object PrepareNBTBase(Map<String, Object> params)
	{
		try
		{
			Object nbtTagCompound = _nbtTagCompound.newInstance();

			return PrepareNBTBase(nbtTagCompound, params);
		}
		catch (InstantiationException | IllegalAccessException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	public abstract Object PrepareNBTBase(Object nbtBase, Map<String, Object> params);

	public static NBTAbstractValue<?> PrepareNBTVariable(Object nbtBase)
	{
		Class<?> clazz = nbtBase.getClass();

		NBTAbstractValue<?> res = CreateVariable(null, clazz);

		res.LoadNBTBase(nbtBase);

		return res;
	}

	protected static NBTAbstractValue<?> CreateVariable(String path, Class<?> clazz)
	{
		NBTAbstractValue<?> res;

		if (_nbtTagCompound.isAssignableFrom(clazz))
		{
			res = new NBTTagCompoundValue(path);
		}
		else if (_nbtTagIntArray.isAssignableFrom(clazz))
		{
			res = new NBTArrayValue<Integer>(path);
		}
		else if (_nbtTagByteArray.isAssignableFrom(clazz))
		{
			res = new NBTArrayValue<Byte>(path);
		}
		else if (_nbtTagList.isAssignableFrom(clazz))
		{
			res = new NBTListValue(path);
		}
		else if (_nbtBase.isAssignableFrom(clazz))
		{
			res = new NBTPrimitiveValue(path);
		}
		else
		{
			throw new IllegalArgumentException(
					"Given object is not of the type of NBTBase or is of the type inheriting NBTBase but not supported.");
		}

		return res;
	}

	protected abstract void LoadNBTBase(Object nbtBase);

	public Object DigNBTBase(Object nbtTagCompound)
	{
		return DigNBTBase(nbtTagCompound, GetPath());
	}

	public static Object DigNBTBase(Object nbtBase, String path)
	{
		return DigNBTBase(nbtBase, path, 0);
	}

	public static Object DigNBTBase(Object nbtBase, String path, int backIndex)
	{
		try
		{
			if (path == null || path.isEmpty())
			{
				return nbtBase;
			}
			else
			{
				String[] pathAr = path.split("\\.");

				Field field = _nbtTagCompound.getDeclaredField("map");
				field.setAccessible(true);

				if (nbtBase == null)
				{
					nbtBase = _nbtTagCompound.newInstance();
				}

				for (int i = 0; i < pathAr.length - backIndex; i++)
				{
					if ((boolean) _nTC_hasKey.invoke(nbtBase, pathAr[i]))
					{
						nbtBase = _nTC_getCompound.invoke(nbtBase, pathAr[i]);
					}
					else
					{
						Map<String, Object> map = (Map<String, Object>) field.get(nbtBase);

						nbtBase = _nbtTagCompound.newInstance();

						map.put(pathAr[i], nbtBase);
					}
				}

				return nbtBase;
			}
		}
		catch (IllegalAccessException | InvocationTargetException | SecurityException ex)
		{
			ex.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			e.printStackTrace();
		}
		catch (InstantiationException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (NoSuchFieldException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}
}
