package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import org.bukkit.Material;

import an0nym8us.bukkit.magicCrafting.ISBuilder;

public class MaterialVariable implements Variable<String>
{
	Variable<Number> id;

	public MaterialVariable(Variable<Number> id)
	{
		this.id = id;
	}

	@Override
	public String GetValue(Map<String, Object> params)
	{
		Material mat = Material.getMaterial(id.GetValue(params).intValue());
		
		if(mat == null) { return "minecraft.air"; }
		
		String res = ISBuilder.GetMCID(mat);
		
		return res == null ? "minecraft.air" : res;
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, String value)
	{
		return GetValue(params).equals(value);
	}

	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(id, output);
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		id = (Variable<Number>) Warmonger.Read(input);
	}
}
