package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LocationVariable<T> implements Variable<T>, ISettable<T>
{
	public static enum LocationVariableType
	{
		X(), Y(), Z(), YAW(), PITCH(), WORLD();

		public Object GetValue(Location loc)
		{
			switch (this)
			{
				case X:
					return loc.getX();
				case Y:
					return loc.getY();
				case Z:
					return loc.getZ();
				case YAW:
					return loc.getYaw();
				case PITCH:
					return loc.getPitch();
				case WORLD:
					return loc.getWorld();
				default:
					return null;
			}
		}
		
		public boolean SetValue(Location loc, Object value)
		{
			switch (this)
			{
				case X:
					loc.setX((double) value);
					break;
				case Y:
					loc.setY((double) value);
					break;
				case Z:
					loc.setZ((double) value);
					break;
				case YAW:
					loc.setYaw((float) value);
					break;
				case PITCH:
					loc.setPitch((float) value);
					break;
				case WORLD:
					loc.setWorld(Bukkit.getWorld((UUID)value));
					break;
				default:
					return false;
			}
			
			return true;
		}
	}

	LocationVariableType locVariableType;
	Variable<Location> location;

	public LocationVariable(Variable<Location> location)
	{
		this.location = location;
	}

	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeUTF(locVariableType.name());
		location.Write(output);
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		location = (Variable<Location>) Warmonger.Read(input);
		locVariableType = LocationVariableType.valueOf(input.readUTF());
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		return (T) locVariableType.GetValue(location.GetValue(params));
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return locVariableType.GetValue(location.GetValue(params)).equals(value);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		return locVariableType.SetValue(location.GetValue(params), value);
	}

}
