package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class LocalVariable<T> implements Variable<T>, ISettable<T>, IDeleteable<T>
{
	String name;
	
	public LocalVariable(String name)
	{
		this.name = name;
	}
	
	public String GetName()
	{
		return name;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		name = input.readUTF();
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeUTF(name);
	}
	
	@Override
	public T GetValue(Map<String, Object> params)
	{
		return (T) params.get(name);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		params.put(name, value);
		
		return true;
	}

	@Override
	public boolean SetValue(Map<String, Object> params, Variable<T> value)
	{
		return SetValue(params, value.GetValue(params));
	}

	@Override
	public boolean DeleteValue(Map<String, Object> params)
	{
		params.remove(name);
		
		return true;
	}
	
	@Override
	public boolean DoesMatch(final Map<String, Object> params, T value)
	{
		return params.get(GetName()).equals(value);
	}

	@Override
	public boolean DoesMatch(final Map<String, Object> params, Variable<T> value)
	{
		return DoesMatch(params, value.GetValue(params));
	}
}
