package an0nym8us.warmonger;

import java.util.HashMap;
import java.util.Map;

public class GlobalVariable<T> extends LocalVariable<T>
{
	public static final Map<String, Object> params = new HashMap<String, Object>();
	
	public GlobalVariable(String name)
	{
		super(name);
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		return (T) GlobalVariable.params.get(name);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		GlobalVariable.params.put(name, value);
		
		return true;
	}
	
	@Override
	public boolean DeleteValue(Map<String, Object> params)
	{
		GlobalVariable.params.remove(name);
		
		return true;
	}
	
	@Override
	public boolean DoesMatch(final Map<String, Object> params, T value)
	{
		return GlobalVariable.params.get(GetName()).equals(value);
	}
}
