package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nullable;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

import an0nym8us.bukkit.magicCrafting.NMSProvider;

public class EntityVariable<T> implements Variable<T>, ISettable<T>
{
	public static final String ENTITY_CODE = "entity";

	protected static Class<?> _nbtTagCompound;
	protected static Class<?> _craftEntity;
	protected static Class<?> _entity;

	protected static Method _cE_getHandle;
	protected static Method _e_readNBT;
	protected static Method _e_writeNBT;

	static
	{
		try
		{
			_nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagCompound");
			_craftEntity = NMSProvider
					.GetClass("org.bukkit.craftBukkit" + NMSProvider.GetNMSVersion() + ".Entity");
			_entity = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".Entity");

			_cE_getHandle = NMSProvider.GetMethod(_craftEntity, "getHandle");
			_e_readNBT = NMSProvider.GetMethod(_entity, "a", _nbtTagCompound);
			_e_writeNBT = NMSProvider.GetMethod(_entity, "b", _nbtTagCompound);
		}
		catch (ClassNotFoundException | NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
		}
	}

	Variable<Number> entityId;
	@Nullable Variable<UUID> world;
	
	Variable<NBTAbstractValue<T>> nbtValue;

	public EntityVariable(NBTAbstractValue<T> nbtValue)
	{
		this.nbtValue = new Constant<NBTAbstractValue<T>>(nbtValue);
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		entityId = (Variable<Number>) Warmonger.Read(input);
		world = (Variable<UUID>) Warmonger.Read(input);
		
		nbtValue = (Variable<NBTAbstractValue<T>>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(entityId, output);
		Warmonger.Write(world, output);
		
		Warmonger.Write(nbtValue, output);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		try
		{
			Object entity = GetNMSEntity(params);
			
			Object nbtTagCompound = _nbtTagCompound.newInstance();

			_e_writeNBT.invoke(entity, nbtTagCompound);

			if(!nbtValue.GetValue(params).SetValue(nbtTagCompound, value)) { return false; }
			
			_e_readNBT.invoke(entity, nbtTagCompound);
			
			return true;
		}
		catch (IllegalAccessException | SecurityException e)
		{
			e.printStackTrace();
		}
		catch (InstantiationException | IllegalArgumentException | InvocationTargetException e)
		{

		}

		return false;
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		try
		{
			return nbtValue.GetValue(params).GetValue(GetEntityNBT(params));
		}
		catch (IllegalArgumentException	| SecurityException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	protected Object GetEntityNBT(Map<String, Object> params)
	{
		try
		{
			Object nbtTagCompound = _nbtTagCompound.newInstance();

			_e_writeNBT.invoke(GetNMSEntity(params), nbtTagCompound);

			return nbtTagCompound;
		}
		catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
				| SecurityException e)
		{
			e.printStackTrace();
		}

		return null;
	}
	
	protected Object GetNMSEntity(Map<String, Object> params)
	{
		try
		{
			return _cE_getHandle.invoke(GetEntity(params));
		}
		catch (InvocationTargetException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			
		}
		
		return null;
	}
	
	protected Entity GetEntity(Map<String, Object> params)
	{
		int entityID = entityId.GetValue(params).intValue();
		
		if(world == null)
		{
			Collection<Entity> coll;
			
			for(World world : Bukkit.getWorlds())
			{
				coll = world.getEntities();
				
				for(Entity entity : coll)
				{
					if(entity.getEntityId() == entityID)
					{
						return entity;
					}
				}
			}
		}
		else
		{
			Collection<Entity> coll = Bukkit.getWorld(world.GetValue(params)).getEntities();
			
			for(Entity entity : coll)
			{
				if(entity.getEntityId() == entityID)
				{
					return entity;
				}
			}
		}
		
		return null;
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return GetValue(params).equals(value);
	}
}
