package an0nym8us.warmonger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

public class Constant<T> implements Variable<T>
{
	T value;
	
	public Constant(T value)
	{
		this.value = value;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		int length = input.readInt();
		byte[] array = new byte[length];
		
		input.readFully(array);
		
		ByteArrayInputStream bais = new ByteArrayInputStream(array);
		ObjectInputStream ois = new ObjectInputStream(bais);
		
		try
		{
			value = (T)ois.readObject();
		}
		catch (ClassNotFoundException e)
		{
			e.printStackTrace();
		}
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ObjectOutputStream oos = new ObjectOutputStream(baos);
		
		oos.writeObject(value);
		
		byte[] ar = baos.toByteArray();
		
		output.writeInt(ar.length);
		output.write(ar);
	}
	
	@Override
	public T GetValue(Map<String, Object> params)
	{
		return value;
	}
	
	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return this.value.equals(value);
	}
	
	@Override
	public boolean DoesMatch(Map<String, Object> params, Variable<T> value)
	{
		return this.value.equals(value.GetValue(params));
	}
}
