package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.functions.Function;

public class ConditionedProgram extends Program
{
	Variable<Boolean>[] conditions;

	public ConditionedProgram(Function<?>[] functions)
	{
		this(functions, null);
	}

	public ConditionedProgram(Function<?>[] actions, Variable<Boolean>[] conditions)
	{
		super(actions);

		this.conditions = conditions;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(conditions.length);
		
		for(Variable<Boolean> condition : conditions)
		{
			Warmonger.Write(condition, output);
		}
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		conditions = new Variable[input.readInt()];
		
		for(int i = 0; i < functions.length; i++)
		{
			conditions[i] = (Variable<Boolean>) Warmonger.Read(input);
		}
	}

	@Override
	public Variable<Integer> Execute(Map<String, Object> params)
	{
		if (conditions != null)
		{
			for (Variable<Boolean> conditions : conditions)
			{
				if (!conditions.GetValue(params)) { return new Constant<Integer>(GENERAL_FAILURE_CODE); }
			}
		}

		for (Function<?> function : functions)
		{
			if (IsAborted(params)) { return new Constant<Integer>(SUCCESS_CODE); }

			function.Execute(params);
		}

		return new Constant<Integer>(SUCCESS_CODE);
	}
}
