package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class ConditionVariable<T> implements Variable<Boolean>
{
	Variable<T> nativeValue;
	Variable<T> comparedValue;
	
	public ConditionVariable(Variable<T> nativeValue, Variable<T> comparedValue)
	{
		this.nativeValue = nativeValue;
		this.comparedValue = comparedValue;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		nativeValue = (Variable<T>) Warmonger.Read(input);
		comparedValue = (Variable<T>)Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(nativeValue, output);
		Warmonger.Write(comparedValue, output);
	}
	
	@Override
	public Boolean GetValue(Map<String, Object> params)
	{
		return nativeValue.DoesMatch(params, comparedValue);
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, Boolean value)
	{
		return value == GetValue(params);
	}
}
