package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;

public class BlockVariable implements Variable<Number>, ISettable<Number>
{
	public static enum BlockValueType
	{
		MATERIAL(), LIGHT_LEVEL_SKY(), LIGHT_LEVEL_BLOCKS(), BLOCK_DATA(), BIOME();
	}

	Variable<UUID> world;
	Variable<Number> x;
	Variable<Number> y;
	Variable<Number> z;

	BlockValueType blockValueType;

	boolean relativeToAltar;

	public BlockVariable(Variable<UUID> world, Variable<Number> x, Variable<Number> y, Variable<Number> z,
			BlockValueType blockValueType)
	{
		this(world, x, y, z, blockValueType, true);
	}

	public BlockVariable(Variable<UUID> world, Variable<Number> x, Variable<Number> y, Variable<Number> z,
			BlockValueType blockValueType, boolean relativeToAltar)
	{
		this.world = world;
		this.x = x;
		this.y = y;
		this.z = z;

		this.blockValueType = blockValueType;

		this.relativeToAltar = relativeToAltar;
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		world = (Variable<UUID>) Warmonger.Read(input);
		x = (Variable<Number>) Warmonger.Read(input);
		y = (Variable<Number>) Warmonger.Read(input);
		z = (Variable<Number>) Warmonger.Read(input);
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(world, output);
		Warmonger.Write(x, output);
		Warmonger.Write(y, output);
		Warmonger.Write(z, output);
	}

	@Override
	public Number GetValue(Map<String, Object> params)
	{
		Block block = GetBlock(params);

		switch (blockValueType)
		{
			case MATERIAL:
				return block.getTypeId();
			case LIGHT_LEVEL_SKY:
				return block.getLightFromSky();
			case LIGHT_LEVEL_BLOCKS:
				return block.getLightFromBlocks();
			case BLOCK_DATA:
				return block.getData();
			case BIOME:
				return GetBiomeID(block.getBiome());
			default:
				return -1;
		}
	}

	public static final int GetBiomeID(Biome biome)
	{
		return biome.ordinal();

		/*
		 * Biome[] array = Biome.values();
		 * 
		 * for (int i = 0; i < array.length; i++) { if (array[i].equals(biome))
		 * { return i; } }
		 * 
		 * return -1;
		 */
	}

	@Override
	public boolean SetValue(Map<String, Object> params, Number value)
	{
		Block block = GetBlock(params);

		switch (blockValueType)
		{
			case MATERIAL:
				block.setTypeId(value.intValue());

				return true;
			case LIGHT_LEVEL_SKY:

				return false;
			case LIGHT_LEVEL_BLOCKS:

				return false;
			case BLOCK_DATA:
				block.setData(value.byteValue());

				return true;
			case BIOME:
				block.setBiome(GetBiome(value.intValue()));

				return true;
			default:

				return false;
		}
	}

	protected Block GetBlock(Map<String, Object> params)
	{
		return Bukkit.getWorld(this.world.GetValue(params)).getBlockAt((int) x.GetValue(params),
				(int) y.GetValue(params), (int) z.GetValue(params));
	}

	protected Biome GetBiome(int id)
	{
		return Biome.values()[id];
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, Number value)
	{
		return GetValue(params).doubleValue() == value.doubleValue();
	}
}
