package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class ArrayVariable<T> implements Variable<T[]>
{
	Variable<T>[] values;

	ArrayVariable()
	{
	}

	public ArrayVariable(Variable<T>... values)
	{
		this.values = values;
	}

	@Override
	public T[] GetValue(Map<String, Object> params)
	{
		Object[] res = new Object[values.length];

		for (int i = 0; i < values.length; i++)
		{
			res[i] = values[i].GetValue(params);
		}

		return (T[]) res;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		int length = input.readInt();
		
		values = new Variable[length];
		
		for(int i = 0; i < values.length; i++)
		{
			values[i] = (Variable<T>) Warmonger.Read(input);
		}
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(values.length);
		
		for(int i = 0; i < values.length; i++)
		{
			Warmonger.Write(values[i], output);
		}
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T[] values)
	{
		for (Variable<T> value0 : this.values)
		{
			boolean doesMatch = false;

			for (T value1 : values)
			{
				if (value0.DoesMatch(params, value1))
				{
					doesMatch = true;

					break;
				}
			}

			if (!doesMatch) { return false; }
		}

		return true;
	}

}
