package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.bukkit.magicCrafting.altar.AdvancedAltarRecipe;

public class AdvancedRecipeVariable<T> implements Variable<T>, ISettable<T>
{
	public static enum AdvancedRecipeVariableType
	{
		INGREDIENTS(AdvancedAltarRecipe.INGREDIENTS_CODE),
		RESULT(AdvancedAltarRecipe.RESULT_CODE),
		TEMPLATE_INGREDIENTS(AdvancedAltarRecipe.TEMPLATE_INGREDIENTS_CODE),
		TEMPLATE_RESULT(AdvancedAltarRecipe.TEMPLATE_RESULTS_CODE),
		PLAYER_EXECUTOR(AdvancedAltarRecipe.PLAYER_EXECUTOR_CODE),
		PLAYER_OWNER(AdvancedAltarRecipe.PLAYER_OWNER_CODE),
		PRICE(AdvancedAltarRecipe.PRICE_CODE),
		ALTAR_X(AdvancedAltarRecipe.STRUCT_X_CODE),
		ALTAR_Y(AdvancedAltarRecipe.STRUCT_Y_CODE),
		ALTAR_Z(AdvancedAltarRecipe.STRUCT_Z_CODE),
		ALTAR_WORLD(AdvancedAltarRecipe.STRUCT_WORLD_CODE);
		//ALTAR_LOC(AdvancedAltarRecipe.);

		String paramName;
		
		AdvancedRecipeVariableType(String paramName)
		{
			this.paramName = paramName;
		}
		
		public Object GetValue(Map<String, Object> params)
		{
			return params.get(paramName);
		}
		
		public boolean SetValue(Map<String, Object> params, Object value)
		{
			params.put(paramName, value);
			
			return true;
		}
	}

	AdvancedRecipeVariableType type;

	public AdvancedRecipeVariable(AdvancedRecipeVariableType type)
	{
		this.type = type;
	}

	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeUTF(type.name());
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		type = AdvancedRecipeVariableType.valueOf(input.readUTF());
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		return (T) type.GetValue(params);
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return GetValue(params).equals(value);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		return type.SetValue(params, value);
	}
}
