package an0nym8us.utils.menu;

import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

import an0nym8us.processorSession.data.InventoryDataContainer;
import an0nym8us.processorSession.site.ISite;
import an0nym8us.processorSession.site.ISiteSession;

public class SiteMenuInventorySession<TMenu extends SiteMenu<? extends ISite<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession>, TSession>, TSession extends ISiteSession>
		extends MenuInventorySession<TMenu>
{
	public TSession siteSession = null;

	public SiteMenuInventorySession(UUID owner, InventorySessionManager sessionManager, TMenu menu)
	{
		this(Bukkit.createInventory(null, 54), sessionManager, owner, menu);
	}

	protected SiteMenuInventorySession(Inventory inv, InventorySessionManager sessionManager, UUID owner, TMenu menu)
	{
		super(inv, sessionManager, owner, menu);

		// siteSession = menu.GetSite().CreateSession(PrepareContainer(null));
	}

	public ISite<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession> GetSite()
	{
		return menu.GetSite();
	}

	@Override
	public void Dispose()
	{
		if (IsDisposed()) { return; }

		super.Dispose();

		if (siteSession != null && !siteSession.IsDisposed())
		{
			siteSession.Dispose();

			siteSession = null;
		}
	}

	public TSession GetSiteSession()
	{
		if (siteSession == null || siteSession.IsDisposed())
		{
			siteSession = this.GetSite().CreateSession(
					new InventoryDataContainer<MenuConstInventoryDataContainer>(GetDataContainer(), null));
		}

		return siteSession;
	}

	public ISiteSession GetActiveSubSiteSession()
	{
		if (GetSiteSession().HasActiveSubSiteSession()) { return siteSession.GetActiveSubSiteSession(); }

		return null;
	}

	public ISiteSession GetSubSiteSession(int ID)
	{
		return siteSession.GetSubSiteSession(ID);
	}

	@Override
	public boolean Update()
	{
		return GetSite().Update(PrepareContainer(null), GetSiteSession());
	}

	@Override
	public void OnInventoryClick(InventoryClickEvent ev)
	{
		InventoryDataContainer<? extends MenuConstInventoryDataContainer> c = PrepareContainer(ev);

		if (GetSite().Process(null, c, GetSiteSession()))
		{
			Update();
		}
	}

	public boolean DeactiveSubSiteSession()
	{
		return GetSiteSession().UnsetActiveSubSiteSession();
	}

	public boolean SetActiveSubSiteSession(int ID)
	{
		return GetSiteSession().SetActiveSubSiteSessionID(ID);
	}

	protected InventoryDataContainer<? extends MenuConstInventoryDataContainer> PrepareContainer(Event event)
	{
		return new InventoryDataContainer<>(GetDataContainer(), event);
	}
}
