package an0nym8us.utils.menu;

import java.util.UUID;

import org.bukkit.inventory.Inventory;

public abstract class MenuInventorySession<T extends IMenu> extends InventorySession<MenuConstInventoryDataContainer>
{
	protected T menu;
	
	public MenuInventorySession(Inventory inv, InventorySessionManager sessionManager, UUID owner, T menu)
	{
		super();
		
		this.invDataContainer = new MenuConstInventoryDataContainer(sessionManager, this, inv, owner);
		
		this.menu = menu;
	}
	
	public MenuInventorySession(MenuConstInventoryDataContainer dataContainer, T menu)
	{
		super(dataContainer);
		
		this.menu = menu;
	}
	
	public T GetMenu()
	{
		return menu;
	}
}
