package an0nym8us.utils.menu;

import java.util.UUID;

import org.bukkit.inventory.Inventory;

import an0nym8us.processorSession.data.ConstInventoryDataContainer;

public class MenuConstInventoryDataContainer extends ConstInventoryDataContainer
{
	private final InventorySessionManager sessionManager;
	private InventorySession<? super MenuConstInventoryDataContainer> inventorySession;
	
	public MenuConstInventoryDataContainer(InventorySessionManager sessionManager, InventorySession<? super MenuConstInventoryDataContainer> inventorySession, Inventory inventory, UUID owner)
	{
		super(inventory, owner);
		
		this.sessionManager = sessionManager;
		this.inventorySession = inventorySession;
	}
	
	public InventorySessionManager GetSessionManager()
	{
		return sessionManager;
	}
	
	public InventorySession<? super MenuConstInventoryDataContainer> GetInventorySession()
	{
		return inventorySession;
	}
	
	public boolean IsGlobalSession(InventorySession<?> inventorySession)
	{
		return this.inventorySession.equals(inventorySession);
	}
	
	public void DisposeSession()
	{
		sessionManager.DisposeSession(inventorySession);
	}
}
