package an0nym8us.utils.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;

public class InventorySessionManager
{
	List<IInventorySession<?>> sessions;
	
	public InventorySessionManager()
	{
		sessions = Collections.synchronizedList(new ArrayList<IInventorySession<?>>());
	}
	
	public boolean IsSessionInventory(Inventory inv)
	{
		for (IInventorySession<?> session : sessions)
		{
			if (session.IsInventoryEqual(inv)) { return true; }
		}

		return false;
	}
	
	public boolean InsertSession(IInventorySession<?> session)
	{
		sessions.add(session);
		
		Bukkit.getLogger().info("Session inserted. Size: " + sessions.size());
		return true;
	}
	
	public boolean DeleteSession(IInventorySession<?> session)
	{
		if(sessions.contains(session))
		{
			sessions.remove(session);
			Bukkit.getLogger().info("Session deleted. Size: " + sessions.size());
			return true;
		}
		
		return false;
	}
	
	public void Dispose()
	{
		synchronized(sessions)
		{
			for(IInventorySession<?> session : sessions)
			{
				session.Dispose();
			}
			
			sessions = null;
		}
	}
	
	public void DisposeSession(IInventorySession<?> session)
	{
		if(sessions.contains(session))
		{
			sessions.remove(session);
		}
		
		session.Dispose();
	}
	
	public IInventorySession<?> GetSessionByInventory(Inventory inv)
	{
		for (IInventorySession<?> session : sessions)
		{
			if (session.IsInventoryEqual(inv)) { return session; }
		}

		return null;
	}
}
