package an0nym8us.utils.menu;

import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;

public class InventorySessionListener implements Listener
{
	InventorySessionManager sessionManager;

	public InventorySessionListener(InventorySessionManager manager)
	{
		this.sessionManager = manager;
	}

	@EventHandler(priority = EventPriority.LOWEST)
	public void onInventoryClick(InventoryClickEvent ev)
	{
		if (ev.getClickedInventory() == null || ev.getSlot() != ev.getRawSlot()) { return; }

		try
		{
			IInventorySession<?> session = sessionManager.GetSessionByInventory(ev.getClickedInventory());

			if (session != null)
			{
				ev.setCancelled(true);
				
				if (!(ev.getAction().equals(InventoryAction.PICKUP_ALL)
						|| ev.getAction().equals(InventoryAction.PICKUP_HALF)
						|| ev.getAction().equals(InventoryAction.PICKUP_ONE)
						|| ev.getAction().equals(InventoryAction.PICKUP_SOME)
						|| ev.getAction().equals(InventoryAction.PLACE_ALL)
						|| ev.getAction().equals(InventoryAction.PLACE_ONE)
						|| ev.getAction().equals(InventoryAction.PLACE_SOME)
						|| ev.getAction().equals(InventoryAction.SWAP_WITH_CURSOR)))
				{
					return;
				}
				
				session.OnInventoryClick(ev);
			}
		}
		catch (Exception ex)
		{
			ev.setCancelled(true);

			ex.printStackTrace();
		}
	}

	@EventHandler(priority = EventPriority.LOWEST)
	public void onInventoryClose(InventoryCloseEvent ev)
	{
		IInventorySession<?> session = sessionManager.GetSessionByInventory(ev.getInventory());

		if (session != null)
		{
			session.OnInventoryClose(ev);
			
			if (session.IsDisposed())
			{
				sessionManager.DeleteSession(session);
			}
		}
	}

	@EventHandler(priority = EventPriority.LOWEST)
	public void onInventoryDrag(InventoryDragEvent ev)
	{
		IInventorySession<?> session = sessionManager.GetSessionByInventory(ev.getInventory());

		if (session != null)
		{
			session.OnInventoryDrag(ev);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST)
	public void onInventoryInteract(InventoryInteractEvent ev)
	{
		IInventorySession<?> session = sessionManager.GetSessionByInventory(ev.getInventory());

		if (session != null)
		{
			session.OnInventoryInteract(ev);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST)
	public void onInventoryCreative(InventoryCreativeEvent ev)
	{
		IInventorySession<?> session = sessionManager.GetSessionByInventory(ev.getInventory());

		if (session != null)
		{
			session.OnInventoryCreative(ev);
		}
	}
}
