package an0nym8us.utils.menu;

import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;

public abstract class InventorySession<TExtData extends MenuConstInventoryDataContainer> implements IInventorySession<TExtData>
{
	protected TExtData invDataContainer;

	boolean isDisposed;

	public InventorySession()
	{		
		isDisposed = false;
	}
	
	public InventorySession(TExtData invDataContainer)
	{
		this.invDataContainer = invDataContainer;
		
		isDisposed = false;
	}

	public TExtData GetDataContainer()
	{
		return invDataContainer;
	}

	@Override
	public void Dispose()
	{		
		if (invDataContainer.IsGlobalSession(this) && !invDataContainer.IsDisposed())
		{
			invDataContainer.Dispose();
		}
		
		invDataContainer = null;
		
		isDisposed = true;
	}

	public boolean Open()
	{
		if(IsDisposed()) { return false; }
		
		if (Update())
		{
			Bukkit.getPlayer(GetOwner()).openInventory(invDataContainer.GetInventory());

			return true;
		}

		return false;
	}

	@Override
	public boolean IsDisposed()
	{
		return isDisposed;
	}

	@Override
	public Inventory GetInventory()
	{
		return invDataContainer.GetInventory();
	}

	@Override
	public boolean IsInventoryEqual(Inventory inv)
	{
		return this.invDataContainer.GetInventory().hashCode() == inv.hashCode()
				&& this.invDataContainer.GetInventory().equals(inv);
	}

	public boolean HasOwner()
	{
		return GetOwner() != null;
	}

	public boolean IsOwner(UUID owner)
	{
		return GetOwner().equals(owner);
	}

	public UUID GetOwner()
	{
		return invDataContainer.GetOwner();
	}

	@Override
	public void OnInventoryClose(InventoryCloseEvent ev)
	{
	}

	@Override
	public void OnInventoryDrag(InventoryDragEvent ev)
	{
		ev.setCancelled(true);
	}

	@Override
	public void OnInventoryInteract(InventoryInteractEvent ev)
	{
		ev.setCancelled(true);
	}

	@Override
	public void OnInventoryCreative(InventoryCreativeEvent ev)
	{
		ev.setCancelled(true);
	}
}
