package an0nym8us.utils.menu;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ConstantTranslation;
import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;
import an0nym8us.processorSession.InventoryPagedSite;
import an0nym8us.processorSession.InventoryPagedSiteSession;
import an0nym8us.processorSession.data.InventoryDataContainer;
import an0nym8us.processorSession.site.ISiteSession;
import an0nym8us.processorSession.struct.ISessionFactory;

public abstract class InventoryDefaultPagedSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends InventoryPagedSiteSession> extends InventoryPagedSite<TParam, TSession>
{
	protected static final Integer[] elementMap = new Integer[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
			16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
			43, 44 };
	
	static ItemStack PREVIOUS = ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte) 14)
			.SetName(ChatColor.RED + "Previous Site").AddLoreLine(ChatColor.YELLOW + "Switch to previous site")
			.GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.list.nextSite", defaultName = "bNext Site",
			desc = "eSwitch to next site")
	static ItemStack NEXT = ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte) 5)
			.SetName(ChatColor.GREEN + "Next Site").AddLoreLine(ChatColor.YELLOW + "Switch to next site").GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.back", defaultName = "bBack to the main menu",
			desc = "aBack to the main menu")
	static ItemStack BACK = ISBuilder.CreateIS(Material.ARROW).SetName(ChatColor.YELLOW + "Back")
			.AddLoreLine(ChatColor.GREEN + "Back to the main menu").GetResult();
	
	private static final int _1_PREVIOUS_INDEX = 9;
	private static final int _1_NEXT_INDEX = 1;
	private static final int _1_BACK_INDEX = 5;

	int size;

	public InventoryDefaultPagedSite(String title, int size, ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
	{
		super(title, PrepareStaticContent(size), sessionFactory);

		this.size = size;
	}

	protected static ItemStack[] PrepareStaticContent(int size)
	{
		ItemStack[] content = new ItemStack[size];

		for (int i = 0; i < size; i++)
		{
			content[i] = i < size - 9 ? IMenu.DARK_EMPTY_SLOT.clone() : IMenu.LIGHT_EMPTY_SLOT.clone();
		}

		String currentSiteStr = LanguageManager.GetFormattedText("AdminMenu.list.currentSite", "1");
		
		content[size - _1_PREVIOUS_INDEX] = new ISBuilder(PREVIOUS.clone()).AddLoreLine(currentSiteStr).GetResult();
		content[size - _1_BACK_INDEX] = BACK.clone();
		content[size - _1_NEXT_INDEX] = new ISBuilder(NEXT.clone()).AddLoreLine(currentSiteStr).GetResult();

		return content;
	}

	@Override
	public int GetElementsPerPage(TSession siteSession)
	{
		return size - 9;
	}
	
	@Override
	public Integer[] GetElementMap(TSession siteSession)
	{
		return elementMap;
	}
	
	protected boolean BackToSuperSiteSession(ISiteSession caller, TParam extData, TSession siteSession)
	{
		return caller.UnsetActiveSubSiteSession();
	}
	
	@Override
	public boolean OnInventoryClick(InventoryClickEvent ev, ISiteSession caller, TParam extData, TSession siteSession)
	{
		boolean res = super.OnInventoryClick(ev, caller, extData, siteSession);
		
		int slot = ev.getRawSlot();
		
		if (slot == size - _1_PREVIOUS_INDEX)
		{
			res |= PreviousPage(siteSession);
		}
		else if (slot == size - _1_NEXT_INDEX)
		{
			res |= NextPage(siteSession);
		}
		else if (slot == size - _1_BACK_INDEX && caller != null)
		{
			res |= BackToSuperSiteSession(caller, extData, siteSession);
		}
		
		return res;
	}

	@Override
	public ItemStack[] GetContent(TSession siteSession)
	{
		ItemStack[] content = super.GetContent(siteSession);
		ItemStack[] res = new ItemStack[content.length];

		for (int i = 0; i < content.length; i++)
		{
			res[i] = content[i].clone();
		}

		//if (!(siteSession instanceof PagedSiteSession)) { return res; }
		
		Integer[] elementMap = GetElementMap(siteSession);
		ItemStack[] elements = GetElements(siteSession);

		int startIndex = siteSession.GetCurrentPageID() * GetElementsPerPage(siteSession);
		for (int i = 0; i < GetElementsPerPage(siteSession) && i < elementMap.length && i + startIndex < elements.length; i++)
		{
			res[elementMap[i]] = elements[i + startIndex];
		}

		return res;
	}
}
