package an0nym8us.utils.menu;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ConstantTranslation;
import an0nym8us.bukkit.magicCrafting.ISBuilder;

public interface IMenu
{
	static final ItemStack DARK_EMPTY_SLOT = new ItemStack(Material.STAINED_GLASS_PANE, 1, (byte) 15);
	static ItemStack LIGHT_EMPTY_SLOT = new ItemStack(Material.STAINED_GLASS_PANE, 1, (byte) 4);
	static ItemStack GREEN_EMPTY_SLOT = new ItemStack(Material.STAINED_GLASS_PANE, 1, (byte) 5);
	static ItemStack RED_EMPTY_SLOT = new ItemStack(Material.STAINED_GLASS_PANE, 1, (byte) 14);

	@ConstantTranslation(nameCode = "AdminMenu.list.modify", defaultName = "6Modify Recipe",
			desc = { "eTo modify recipe you need to create Recipe Creator Structure first." })
	static ItemStack MODIFY = ISBuilder.CreateIS(Material.TRIPWIRE_HOOK)
			.SetName(ChatColor.GOLD + "Modify Recipe").GetResult();
	@ConstantTranslation(nameCode = "AdminMenu.impresentable", defaultName = "bImpresentable Recipe")
	static ItemStack IMPRESENTABLE_RECIPE = ISBuilder.CreateIS(Material.BARRIER)
			.SetName(ChatColor.DARK_RED + "Impresentable Recipe").GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.list.remove", defaultName = "bRemove Recipe")
	static ItemStack REMOVE = ISBuilder.CreateIS(Material.TRIPWIRE_HOOK)
			.SetName(ChatColor.GREEN + "Remove Recipe").GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.list.previousSite", defaultName = "cPrevious Site",
			desc = "eSwitch to previous site")
	static ItemStack PREVIOUS = ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte) 14)
			.SetName(ChatColor.RED + "Previous Site").AddLoreLine(ChatColor.YELLOW + "Switch to previous site")
			.GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.list.nextSite", defaultName = "bNext Site",
			desc = "eSwitch to next site")
	static ItemStack NEXT = ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte) 5)
			.SetName(ChatColor.GREEN + "Next Site").AddLoreLine(ChatColor.YELLOW + "Switch to next site").GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.back", defaultName = "bBack to the main menu",
			desc = "aBack to the main menu")
	static ItemStack BACK = ISBuilder.CreateIS(Material.ARROW).SetName(ChatColor.YELLOW + "Back")
			.AddLoreLine(ChatColor.GREEN + "Back to the main menu").GetResult();
}
