package an0nym8us.utils.menu;

import java.util.UUID;

import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;

import an0nym8us.bukkit.magicCrafting.IDisposable;
import an0nym8us.processorSession.data.ConstInventoryDataContainer;
import an0nym8us.processorSession.data.InventoryDataContainer;

public interface IInventorySession<T extends ConstInventoryDataContainer> extends IDisposable
{	
	public Inventory GetInventory();
	
	public boolean Update();
	
	public boolean IsInventoryEqual(Inventory inv);
	
	public boolean HasOwner();

	public boolean IsOwner(UUID owner);

	public UUID GetOwner();
	
	public T GetDataContainer();
	
	public void OnInventoryClick(InventoryClickEvent ev);
	
	public void OnInventoryClose(InventoryCloseEvent ev);
	
	public void OnInventoryDrag(InventoryDragEvent ev);
	
	public void OnInventoryInteract(InventoryInteractEvent ev);
	
	public void OnInventoryCreative(InventoryCreativeEvent ev);
}
