package an0nym8us.cyanide;

import java.util.UUID;

import org.bukkit.Bukkit;

import an0nym8us.bukkit.magicCrafting.Main;

public abstract class TextCreationInterface<T> implements ICreationInterface<T>, IOwnerable, IEventable<T>
{
	UUID owner;
	private String text;
	
	ICreationHandler<T> creationHandler;

	public TextCreationInterface(UUID owner)
	{
		this(owner, null);
	}
	
	public TextCreationInterface(UUID owner, ICreationHandler<T> creationHandler)
	{
		this.owner = owner;
		text = null;
		this.creationHandler = creationHandler;
	}

	public UUID GetOwner()
	{
		return owner;
	}
	
	public int Status()
	{
		return text == null ? -1 : 1;
	}
	
	public boolean HasCreationHandler()
	{
		return creationHandler != null;
	}
	
	public ICreationHandler<T> GetCreationHandler()
	{
		return creationHandler;
	}
	
	public boolean SetCreationHandler(ICreationHandler<T> creationHandler)
	{
		this.creationHandler = creationHandler;
		
		return true;
	}

	protected boolean HasReceivedText()
	{
		return text != null;
	}

	public void SetText(String text)
	{
		this.text = text;
		
		if(HasCreationHandler())
		{
			creationHandler.onCreationHandle(this);
		}
		
		synchronized (this)
		{
			this.notify();
		}
	}

	@Override
	public boolean BeginCreation()
	{
		Bukkit.getPlayer(owner).sendMessage("[INPUT] Enter here: ");
		Main.GetInstance().GetTextCreationListener().AddInterface(this);
		
		return true;
	}
	
	public String GetText()
	{
		synchronized (this)
		{
			while (!HasReceivedText())
			{
				try
				{
					this.wait();
				}
				catch (InterruptedException e)
				{
					e.printStackTrace();

					return null;
				}
			}

			return text;
		}
	}
}
