package an0nym8us.cyanide;

public class StaticCreationInterface<T> implements ICreationInterface<T>
{
	T obj;
	ICreationHandler<T> creationHandler;
	
	public StaticCreationInterface(T obj, ICreationHandler<T> creationHandler)
	{
		this.obj = obj;
		this.creationHandler = creationHandler;
	}

	@Override
	public boolean BeginCreation()
	{
		return false;
	}

	@Override
	public T Return()
	{
		return obj;
	}

	@Override
	public boolean HasCreationHandler()
	{
		return creationHandler != null;
	}

	@Override
	public ICreationHandler<T> GetCreationHandler()
	{
		return creationHandler;
	}

	@Override
	public boolean SetCreationHandler(ICreationHandler<T> creationHandler)
	{
		this.creationHandler = creationHandler;
		
		return true;
	}
}
