package an0nym8us.cyanide;

import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.UUID;

public class NumberTextCreationInterface<T extends Number> extends TextCreationInterface<T>
{
	Class<T> targetClazz;
	
	public NumberTextCreationInterface(UUID owner, ICreationHandler<T> creationHandler, Class<T> targetClazz)
	{
		super(owner, creationHandler);
		
		this.targetClazz = targetClazz;
	}
	
	public NumberTextCreationInterface(CreationInterfaceFactoryData<T> data)
	{
		this(data.player, data.creationHandler, data.targetClazz);
	}

	@SuppressWarnings("unchecked")
	@Override
	public T Return()
	{
		try
		{
			return (T) targetClazz.getDeclaredConstructors()[0].newInstance(NumberFormat.getInstance().parse(GetText()).doubleValue());
		}
		catch (ParseException | NullPointerException | InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException | SecurityException e)
		{
			
		}
		
		return null;
	}
}
