package an0nym8us.cyanide;

import java.util.UUID;

import an0nym8us.bukkit.magicCrafting.IDisposable;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.cyanide.CreationChoiceMenu.CreationChoiceMenuSession;
import an0nym8us.utils.menu.InventorySessionManager;

public class CreationModule<T> implements ICreationHandler<Class<? extends ICreationInterface<? extends T>>>, ICreationInterface<T>, IDisposable
{ 
	CreationChoiceMenuSession<T> ccms;
	
	Class<T> clazz;
	ICreationHandler<T> creationHandler;

	ICreationInterface<T> interFace;
	
	public CreationModule(CreationInterfaceFactoryData<T> data)
	{
		this(new CreationChoiceMenuSession<T>(data.player, Main.GetInstance().GetSessionManager(), CreationChoiceMenu.GetInstance(),
				null, data.targetClazz), data.targetClazz, data.creationHandler);
	}
	
	public CreationModule(CreationChoiceMenuSession<T> choiceSession, Class<T> clazz,
			ICreationHandler<T> creationHandler)
	{
		this.clazz = clazz;
		this.creationHandler = creationHandler;
		
		this.ccms = choiceSession;
		
		choiceSession.SetCreationHandler(this);
		
		Main.GetInstance().GetSessionManager().InsertSession(ccms);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void onCreationHandle(ICreationInterface<Class<? extends ICreationInterface<? extends T>>> creationInterface)
	{		
		try
		{
			interFace = (ICreationInterface<T>) CreationManager.CreateInterface(creationInterface.Return(),
					new CreationInterfaceFactoryData<>(ccms.GetOwner(), new ICreationHandler<T>()
							{
								@Override
								public void onCreationHandle(ICreationInterface<T> creationInterface2)
								{
									CreationModule.this.creationHandler.onCreationHandle(creationInterface2);
								}

								@Override
								public void onErrorHandle(ICreationInterface<T> creationInterface, int code)
								{
									UUID owner = ccms.GetOwner();
									InventorySessionManager sessionManager = ccms.GetDataContainer().GetSessionManager();
									
									ccms.Dispose();
									
									ccms = new CreationChoiceMenuSession<T>(owner, sessionManager, CreationChoiceMenu.GetInstance(),
											CreationModule.this, clazz);
									Main.GetInstance().GetSessionManager().InsertSession(ccms);
									
									ccms.Open();
									
									return;
								}
							}, clazz));

			Main.GetInstance().GetSessionManager().DeleteSession(ccms);
			
			interFace.BeginCreation();
		}
		catch (NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static <T> CreationModule<T> Create(UUID owner, Class<T> clazz, ICreationHandler<T> creationHandler)
	{
		CreationChoiceMenuSession<T> ccms = new CreationChoiceMenuSession<T>(owner, Main.GetInstance().GetSessionManager(), CreationChoiceMenu.GetInstance(),
				null, clazz);
		CreationModule<T> cmms = new CreationModule<T>(ccms, clazz, creationHandler);

		return cmms;
	}

	@Override
	public boolean BeginCreation()
	{
		return ccms.Open();
	}

	@Override
	public T Return()
	{
		return interFace.Return();
	}

	@Override
	public boolean HasCreationHandler()
	{
		return creationHandler != null;
	}

	@Override
	public ICreationHandler<T> GetCreationHandler()
	{
		return creationHandler;
	}

	@Override
	public boolean SetCreationHandler(ICreationHandler<T> creationHandler)
	{
		this.creationHandler = creationHandler;
		
		return true;
	}

	@Override
	public void onErrorHandle(ICreationInterface<Class<? extends ICreationInterface<? extends T>>> creationInterface,
			int code)
	{
		interFace = null;
			
		creationHandler.onErrorHandle(this, 0);
			
		return;
	}

	@Override
	public void Dispose()
	{
		
	}

	@Override
	public boolean IsDisposed()
	{
		// TODO Auto-generated method stub
		return false;
	}
}
