package an0nym8us.cyanide;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;

import an0nym8us.bukkit.magicCrafting.menu.CreationMenu.CreationMenuSession;
import an0nym8us.utils.Pair;

@SuppressWarnings("unchecked")
public final class CreationManager
{
	private static final ConstructorBasedCreationInterfaceFactory<ICreationInterface<?>> factory = new ConstructorBasedCreationInterfaceFactory<ICreationInterface<?>>();	
	private static final Multimap<ClassRange, Pair<Class<? extends ICreationInterface<?>>, ICreationInterfaceFactory<? extends ICreationInterface<?>, ?>>> map = HashMultimap.create();
	
	public static <T> void AddCreationInterface(ClassRange range, Class<? extends ICreationInterface<? extends T>> interfaceType, ICreationInterfaceFactory<? extends ICreationInterface<? extends T>, ?> factory)
	{
		map.put(range, new Pair<Class<? extends ICreationInterface<?>>, ICreationInterfaceFactory<? extends ICreationInterface<?>, ?>>(interfaceType, factory));
	}
	
	public static <T> void AddCreationInterface(ClassRange range, Class<? extends ICreationInterface<? extends T>> interfaceType)
	{
		map.put(range, new Pair<Class<? extends ICreationInterface<?>>, ICreationInterfaceFactory<? extends ICreationInterface<?>, ?>>(interfaceType, factory));
	}

	static
	{
		AddCreationInterface(ClassRange.GLOBAL, (Class<? extends ICreationInterface<?>>) CreationMenuSession.class);
		AddCreationInterface(ClassRange.Create(Integer.class), (Class<NumberTextCreationInterface<Integer>>) (Class<?>) NumberTextCreationInterface.class);
		AddCreationInterface(ClassRange.Create(Number.class), (Class<NumberTextCreationInterface<Number>>) (Class<?>) NumberTextCreationInterface.class);
		AddCreationInterface(ClassRange.Create(Float.class), (Class<NumberTextCreationInterface<Float>>) (Class<?>) NumberTextCreationInterface.class);
		AddCreationInterface(ClassRange.Create(String.class), (Class<StringTextCreationInterface>) (Class<?>) StringTextCreationInterface.class);
	}

	/*public static <T> List<Class<? extends ICreationInterface<? extends T>>> GetCorrespondingInterfaces(Class<T> clazz)
	{
		List<Class<? extends ICreationInterface<? extends T>>> list = new ArrayList<Class<? extends ICreationInterface<? extends T>>>();

		for (Entry<ClassRange, Class<? extends ICreationInterface<?>>> en : map.entries())
		{
			if (en.getKey().DoesMatch(clazz))
			{
				list.add((Class<? extends ICreationInterface<? extends T>>) en.getValue());
			}
		}

		return list;
	}
	
	//public static <T> CreationInterface<T> CreateInterface(Class<? extends CreationInterface<?>>)

	public static <T> Class<? extends ICreationInterface<? extends T>>[] GetCorrespondingInterfacesArray(Class<T> clazz)
	{
		List<Class<? extends ICreationInterface<? extends T>>> list = GetCorrespondingInterfaces(clazz);

		return list.toArray(new Class[list.size()]);
	}*/

	public static <T> List<Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>>> GetInterfaceMap(Class<T> clazz)
	{
		List<Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>>> res = new ArrayList<Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>>>();
		
		for (Entry<ClassRange, Pair<Class<? extends ICreationInterface<?>>, ICreationInterfaceFactory<? extends ICreationInterface<?>, ?>>> en : map.entries())
		{
			if (en.getKey().DoesMatch(clazz))
			{
				res.add(new Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>>(en.getKey(), (Class<? extends ICreationInterface<? extends T>>) en.getValue().GetFirst()));
			}
		}
		
		return res;
	}

	public static <T extends ICreationInterface<?>> T CreateInterface(Class<T> interfaceClazz, CreationInterfaceFactoryData<?> data) throws NoSuchMethodException
	{
		try
		{
			for (Entry<ClassRange, Pair<Class<? extends ICreationInterface<?>>, ICreationInterfaceFactory<? extends ICreationInterface<?>, ?>>> en : map.entries())
			{
				if (en.getValue().GetFirst().equals(interfaceClazz) && en.getValue().GetSecond() instanceof ConstructorBasedCreationInterfaceFactory)
				{
					return ((ConstructorBasedCreationInterfaceFactory<T>)en.getValue().GetSecond()).CreateInterface(data, interfaceClazz);
				}
			}
		}
		catch (SecurityException e)
		{

		}
		catch (IllegalArgumentException e)
		{
			
		}

		return null;
	}
}
