package an0nym8us.cyanide;

import java.util.ArrayList;
import java.util.List;

public class CreationHandlerPackage<T> implements ICreationHandler<T>
{
	List<ICreationHandler<T>> handlers;
	
	public CreationHandlerPackage()
	{
		this.handlers = new ArrayList<ICreationHandler<T>>();
	}
	
	public boolean AddCreationHandler(ICreationHandler<T> creationHandler)
	{
		return handlers.add(creationHandler);
	}
	
	@Override
	public void onCreationHandle(ICreationInterface<T> creationInterface)
	{
		for(ICreationHandler<T> creationHandler : handlers)
		{
			creationHandler.onCreationHandle(creationInterface);
		}
	}

	@Override
	public void onErrorHandle(ICreationInterface<T> creationInterface, int code)
	{
		for(ICreationHandler<T> creationHandler : handlers)
		{
			creationHandler.onErrorHandle(creationInterface, code);
		}
	}
}
