package an0nym8us.cyanide;

import java.util.List;
import java.util.UUID;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.cyanide.CreationChoiceMenu.MainSite.MainSiteSession;
import an0nym8us.processorSession.InventoryPagedSiteSession;
import an0nym8us.processorSession.data.InventoryDataContainer;
import an0nym8us.processorSession.site.ISiteSession;
import an0nym8us.processorSession.struct.ISessionFactory;
import an0nym8us.utils.Pair;
import an0nym8us.utils.menu.InventoryDefaultPagedSite;
import an0nym8us.utils.menu.InventorySessionManager;
import an0nym8us.utils.menu.MenuConstInventoryDataContainer;
import an0nym8us.utils.menu.SiteMenu;
import an0nym8us.utils.menu.SiteMenuInventorySession;
import net.md_5.bungee.api.ChatColor;

public class CreationChoiceMenu extends
		SiteMenu<CreationChoiceMenu.MainSite<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, MainSiteSession<?>>, MainSiteSession<?>>
{
	private static final CreationChoiceMenu instance = new CreationChoiceMenu();

	public static class CreationChoiceMenuSession<T>
			extends SiteMenuInventorySession<CreationChoiceMenu, MainSiteSession<?>>
			implements ICreationInterface<Class<? extends ICreationInterface<? extends T>>>
	{
		ICreationHandler<Class<? extends ICreationInterface<? extends T>>> creationHandler;
		Class<T> clazz;

		public CreationChoiceMenuSession(UUID owner, InventorySessionManager sessionManager, CreationChoiceMenu menu,
				ICreationHandler<Class<? extends ICreationInterface<? extends T>>> creationHandler, Class<T> clazz)
		{
			super(owner, sessionManager, menu);

			this.creationHandler = creationHandler;
			this.clazz = clazz;

			GetDataContainer().SetExternalData("class", clazz);
			
			// siteSession = instance.GetInstance()CreateSiteSession(null,
			// GetDataContainer());
		}

		@Override
		public void Dispose()
		{
			super.Dispose();
		}

		public Class<T> GetClass()
		{
			return clazz;
		}

		@Override
		public boolean BeginCreation()
		{
			return this.Open();
		}

		@SuppressWarnings("unchecked")
		@Override
		public Class<? extends ICreationInterface<? extends T>> Return()
		{
			Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>> pair = ((CreationChoiceMenu.MainSite.MainSiteSession<T>) this
					.GetSiteSession()).GetSelectedElement();
			return pair == null ? null : pair.GetSecond();
		}

		public void CallEnd()
		{
			creationHandler.onCreationHandle(this);
		}

		protected void CallError()
		{
			creationHandler.onErrorHandle(this, 0);
		}

		@Override
		public ICreationHandler<Class<? extends ICreationInterface<? extends T>>> GetCreationHandler()
		{
			return creationHandler;
		}

		@Override
		public boolean SetCreationHandler(
				ICreationHandler<Class<? extends ICreationInterface<? extends T>>> creationHandler)
		{
			this.creationHandler = creationHandler;

			return true;
		}

		@Override
		public boolean HasCreationHandler()
		{
			return creationHandler != null;
		}
	}

	public static class MainSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends MainSite.MainSiteSession<?>>
			extends InventoryDefaultPagedSite<TParam, TSession>
	{
		private static ISessionFactory<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ? extends MainSite.MainSiteSession<?>> sessionFactory = new ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, MainSite.MainSiteSession<?>>()
		{
			@SuppressWarnings({ "unchecked", "rawtypes" })
			public MainSiteSession<?> CreateSession(InventoryDataContainer<? extends MenuConstInventoryDataContainer> parameter)
			{
				return new MainSiteSession(parameter);
			}
		};
		

		public static class MainSiteSession<T> extends InventoryPagedSiteSession
		{
			public List<Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>>> clazzes;
			public ItemStack[] clazzesIS;
			int selectedElement = -1;

			Class<T> nativeClazz;

			public <TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>> MainSiteSession(
					TParam dataPackage)
			{
				this(dataPackage, (Class<T>) dataPackage.GetConstantData().GetExternalData("class"));
			}

			public <TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>> MainSiteSession(
					TParam dataPackage, Class<T> clazz)
			{
				this(dataPackage, clazz, CreationManager.GetInterfaceMap(clazz));
			}

			public <TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>> MainSiteSession(
					TParam dataPackage, Class<T> clazz,
					List<Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>>> clazzes)
			{
				this.nativeClazz = clazz;
				this.clazzes = clazzes;

				clazzesIS = new ItemStack[clazzes.size()];

				int i = 0;
				for (Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>> en : clazzes)
				{
					clazzesIS[i++] = ClassToIS(en.GetFirst(), en.GetSecond());
				}
			}

			protected ItemStack ClassToIS(ClassRange range, Class<? extends ICreationInterface<?>> mappedInterface)
			{
				return ISBuilder.CreateIS(Material.WORKBENCH)
						.SetName(ChatColor.RESET + "" + ChatColor.YELLOW + "Interface: " + ChatColor.GOLD
								+ mappedInterface.getName())
						.SetLore(ChatColor.GREEN + "Certain type of created object: " + ChatColor.RED
								+ range.referenceClass.getName() + ';', ChatColor.RED + "Range of interface:")
						.AddLoreLine(range.GetRange()).AddLoreLine(ChatColor.AQUA + "May be used").GetResult();
			}

			public void SetSelectedElement(int i)
			{
				selectedElement = i;
			}

			public Pair<ClassRange, Class<? extends ICreationInterface<? extends T>>> GetSelectedElement()
			{
				return 0 <= selectedElement && selectedElement < clazzes.size() ? clazzes.get(selectedElement) : null;
			}

			/*
			 * @Override public <TParam extends InventoryDataContainer<? extends
			 * MenuConstInventoryDataContainer>> boolean UnsetActiveSubSiteSession(TParam
			 * dataContainer) {
			 * ((CreationChoiceMenuSession<?>)dataContainer.GetGlobalSession()).CallError();
			 * 
			 * return true; }
			 */
		}

		protected MainSite(ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
		{
			super("Class to Create choice TEST", 54, sessionFactory);
		}
		
		public static MainSite<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, MainSite.MainSiteSession<?>> CreateSite()
		{
			return new MainSite<>(sessionFactory);
		}

		@Override
		public ItemStack[] GetElements(TSession siteSession)
		{
			return siteSession.clazzesIS;
		}

		@Override
		public ItemStack GetElement(TSession siteSession, int index)
		{
			return siteSession.clazzesIS[index];
		}

		@Override
		public int GetElementsAmount(TSession siteSession)
		{
			return siteSession.clazzes.size();
		}

		@Override
		public boolean OnElementClick(int clickedElementIndex, ISiteSession caller, TParam extData, TSession siteSession)
		{
			MainSiteSession<?> s = siteSession;

			s.SetSelectedElement(clickedElementIndex);

			((CreationChoiceMenuSession<?>) extData.GetConstantData().GetInventorySession()).CallEnd();
			
			return true;
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public CreationChoiceMenu()
	{
		super(MainSite.CreateSite());
	}

	public static CreationChoiceMenu GetInstance()
	{
		return instance;
	}
}
