package an0nym8us.cyanide;

public class CreationBinder<T, TParam> implements ICreationInterface<T>, ICreationHandler<T>
{
	ICreationInterface<T> creationInterface;
	ICreationHandler<T> creationHandler;
	TParam param;
	
	public CreationBinder(ICreationInterface<T> creationInterface, TParam param)
	{
		this.creationInterface = creationInterface;
		this.creationHandler = creationInterface.GetCreationHandler();
		this.creationInterface.SetCreationHandler(this);
		
		this.param = param;
	}

	@Override
	public boolean BeginCreation()
	{
		return creationInterface.BeginCreation();
	}

	@Override
	public T Return()
	{
		return creationInterface.Return();
	}

	@Override
	public boolean HasCreationHandler()
	{
		return creationInterface.HasCreationHandler();
	}

	@Override
	public ICreationHandler<T> GetCreationHandler()
	{
		return creationInterface.GetCreationHandler();
	}

	@Override
	public boolean SetCreationHandler(ICreationHandler<T> creationHandler)
	{
		return creationInterface.SetCreationHandler(creationHandler);
	}

	@Override
	public void onCreationHandle(ICreationInterface<T> creationInterface)
	{
		creationHandler.onCreationHandle(this);
	}

	@Override
	public void onErrorHandle(ICreationInterface<T> creationInterface, int code)
	{
		creationHandler.onErrorHandle(this, code);
	}
}
