package an0nym8us.cyanide;

import net.md_5.bungee.api.ChatColor;

public class ClassRange
{
	public static final ClassRange GLOBAL = new ClassRange(Object.class, true, true, true)
	{
		@Override
		public String[] GetRange()
		{
			return new String[] { ChatColor.GREEN + "Global" };
		}
	};

	boolean _super;
	boolean _itself;
	boolean _extends;
	Class<?> referenceClass;

	public ClassRange(Class<?> referenceClass, boolean _super, boolean _itself, boolean _extends)
	{
		this.referenceClass = referenceClass;

		this._super = _super;
		this._itself = _itself;
		this._extends = _extends;
	}

	public static ClassRange Create(Class<?> referenceClass, boolean _super, boolean _itself, boolean _extends)
	{
		return new ClassRange(referenceClass, _super, _itself, _extends);
	}

	public static ClassRange Create(Class<?> referenceClass)
	{
		return new ClassRange(referenceClass, false, true, true);
	}

	public boolean DoesMatch(Class<?> clazz)
	{
		return (_super && referenceClass.isAssignableFrom(clazz)) || (_itself && clazz.equals(referenceClass))
				|| (_extends && clazz.isAssignableFrom(referenceClass));
	}

	public static boolean DoesMatch(Class<?> clazz, ClassRange[] range)
	{
		for (ClassRange r : range)
		{
			if (!r.DoesMatch(clazz)) { return false; }
		}

		return true;
	}

	public String[] GetRange()
	{
		return new String[] {
				_super ? ChatColor.GREEN + "Includes super classes of " + ChatColor.BLUE + "" + referenceClass.getName()
						: ChatColor.RED + "Excludes super classes of " + ChatColor.BLUE + "" + referenceClass.getName(),
				_itself ? ChatColor.GREEN + "Includes " + ChatColor.BLUE + "" + referenceClass.getName()
						: ChatColor.RED + "Excludes super classes of " + ChatColor.BLUE + "" + referenceClass.getName(),
				_extends ? ChatColor.GREEN + "Includes child classes of " + ChatColor.BLUE + ""
						+ referenceClass.getName()
						: ChatColor.GREEN + "Excludes child classes of " + ChatColor.BLUE + ""
								+ referenceClass.getName() };
	}
}
