package an0nym8us.bukkit.magicCrafting.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/**
 * Connects to and uses a MySQL database
 * 
 * @author -_Husky_-
 * @author tips48
 */
public class MySQL extends Database
{
	public static final String RECIPE_TABLE = "recipes";
	public static final String ID_COL_NAME = "id";
	public static final String OBJ_COL_NAME = "object";

	private static boolean isLoaded = false;

	private final String user;
	private final String database;
	private final String password;
	private final String port;
	private final String hostname;

	public MySQL(Plugin plugin, String hostname, int port, String database, String username, String password) throws SQLException
	{
		this(plugin, hostname, Integer.toString(port), database, username, password);
	}

	public MySQL(Plugin plugin, String hostname, String port, String database, String username, String password) throws SQLException
	{
		super(plugin);
		this.hostname = hostname;
		this.port = port;
		this.database = database;
		this.user = username;
		this.password = password;

		try
		{
			OpenConnection();
		}
		catch (ClassNotFoundException e)
		{
			e.printStackTrace();

			return;
		}

		if (!isLoaded)
		{
			_preLoad();
		}
	}

	@Override
	public Connection OpenConnection() throws SQLException, ClassNotFoundException
	{
		if (checkConnection()) { return connection; }

		Class.forName("com.mysql.jdbc.Driver");
		connection = DriverManager.getConnection("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database, this.user, this.password);
		return connection;
	}

	private boolean _preLoad()
	{
		return this.CreateTableIFNE(RECIPE_TABLE, ID_COL_NAME + " int(11) AUTO_INCREMENT PRIMARY KEY, " + OBJ_COL_NAME + " mediumblob NOT NULL");
	}

	private boolean CreateTableIFNE(String tableName, String struct)
	{
		String query = "CREATE TABLE IF NOT EXISTS " + tableName + " (" + struct + ");";

		Statement s = null;

		try
		{
			s = GetConnection().createStatement();
			s.execute(query);
			s.close();

			return true;
		}
		catch (SQLException e)
		{
			Bukkit.getLogger().warning("Cannot create table \"" + tableName + "\" (database connection error?)");
		}
		catch (NullPointerException e)
		{

		}
		finally
		{
			try
			{
				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return false;
	}

	public boolean LockRecipeTable()
	{
		return LockTable(RECIPE_TABLE);
	}

	public boolean LockTable(String tableName)
	{
		String query = "LOCK TABLE " + tableName + " WRITE;";

		Statement s = null;

		try
		{
			s = GetConnection().createStatement();
			s.execute(query);

			return true;
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
		catch (NullPointerException e)
		{

		}
		finally
		{
			try
			{
				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return false;
	}

	public boolean UnlockTables()
	{
		String query = "UNLOCK TABLES;";

		Statement s = null;

		try
		{
			s = GetConnection().createStatement();
			s.execute(query);
			s.close();

			return true;
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
		catch (NullPointerException e)
		{

		}
		finally
		{
			try
			{
				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return false;
	}
}
