package an0nym8us.bukkit.magicCrafting.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/**
 * Abstract Database class, serves as a base for any connection method (MySQL,
 * SQLite, etc.)
 * 
 * @author -_Husky_-
 * @author tips48
 */
public abstract class Database
{
	protected Connection connection;
	protected Plugin plugin;

	protected Database(Plugin plugin)
	{
		this.plugin = plugin;
		this.connection = null;
	}

	public abstract Connection OpenConnection() throws SQLException,
			ClassNotFoundException;

	public boolean checkConnection() throws SQLException
	{
		return connection != null && connection.isValid(1);
	}

	public Connection GetConnection() throws SQLException
	{
		try
		{
			return OpenConnection();
		}
		catch (ClassNotFoundException ex)
		{
			Bukkit.getLogger().warning("SQL Driver Issue: " + ex.toString());
			
			throw new SQLException();
		}
	}

	public boolean closeConnection() throws SQLException
	{
		if (connection == null) { return false; }
		
		connection.close();
		return true;
	}
	
	public boolean normalSQL(String query)
	{
		try
		{
			if (!checkConnection())
			{
				OpenConnection();
			}

			Statement statement = connection.createStatement();

			statement.execute(query);
		}
		catch (Throwable t)
		{
			Bukkit.getLogger().warning("Cannot contact with database error");
			
			if(t instanceof ClassNotFoundException)
			{
				Bukkit.getLogger().warning("ClassNotFoundException");
			}
			
			return false;
		}
		
		return true;
	}

	public ResultSet querySQL(String query)
	{
		try
		{
			if (!checkConnection())
			{
				OpenConnection();
			}

			Statement statement = connection.createStatement();

			ResultSet result = statement.executeQuery(query);

			return result;
		}
		catch (Throwable t)
		{
			Bukkit.getLogger().warning("Cannot contact with database error");
			
			if(t instanceof ClassNotFoundException)
			{
				Bukkit.getLogger().warning("ClassNotFoundException");
			}
			
			return null;
		}
	}

	public int updateSQL(String query)
	{
		try
		{
			if (!checkConnection())
			{
				OpenConnection();
			}

			Statement statement = connection.createStatement();

			int result = statement.executeUpdate(query);

			return result;
		}
		catch (Throwable t)
		{
			Bukkit.getLogger().warning("Cannot contact with database error");
			
			if(t instanceof ClassNotFoundException)
			{
				Bukkit.getLogger().warning("ClassNotFoundException");
			}
			
			return -1;
		}
	}

	public void Dispose()
	{
		try
		{
			this.connection.close();
		}
		catch (Exception e)
		{
			
		}
	}
}