package an0nym8us.bukkit.magicCrafting.menu;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.cyanide.CreationInterfaceFactoryData;
import an0nym8us.cyanide.CreationModule;
import an0nym8us.cyanide.ICreationHandler;
import an0nym8us.cyanide.ICreationInterface;
import an0nym8us.processorSession.InventoryPagedSiteSession;
import an0nym8us.processorSession.data.InventoryDataContainer;
import an0nym8us.processorSession.site.ISiteSession;
import an0nym8us.processorSession.struct.ISessionFactory;
import an0nym8us.utils.menu.InventoryDefaultPagedSite;
import an0nym8us.utils.menu.InventorySessionManager;
import an0nym8us.utils.menu.MenuConstInventoryDataContainer;
import an0nym8us.utils.menu.SiteMenu;
import an0nym8us.utils.menu.SiteMenuInventorySession;

public class CreationMenu extends
		SiteMenu<CreationMenu.ConstructorChooseSite<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, CreationMenu.ConstructorChooseSite.ConstructorChooseSiteSession>, CreationMenu.ConstructorChooseSite.ConstructorChooseSiteSession>
{
	public static CreationMenu instance = new CreationMenu();

	public static class CreationMenuSession<T> extends
			SiteMenuInventorySession<CreationMenu, CreationMenu.ConstructorChooseSite.ConstructorChooseSiteSession>
			implements ICreationInterface<T>
	{
		Class<T> createdObjType;
		ICreationHandler<T> creationHandler;

		private T createdObj = null;

		public CreationMenuSession(CreationInterfaceFactoryData<T> data)
		{
			this(data.player, Main.GetInstance().GetSessionManager(), instance, data.targetClazz, data.creationHandler);
		}

		public CreationMenuSession(UUID owner, InventorySessionManager sessionManager, CreationMenu menu,
				Class<T> clazz, ICreationHandler<T> creationHandler)
		{
			super(owner, sessionManager, menu);

			this.createdObjType = clazz;
			this.creationHandler = creationHandler;

			sessionManager.InsertSession(this);
			
			this.GetDataContainer().SetExternalData("creationClazz", clazz);
			this.GetDataContainer().SetExternalData("creationInterface", this);
			this.GetDataContainer().SetExternalData("creationHandler", creationHandler);
		}

		protected void CallSuccess()
		{
			creationHandler.onCreationHandle(this);
		}

		protected void CallError(int errorCode)
		{
			creationHandler.onErrorHandle(this, errorCode);
		}

		public Class<T> GetClass()
		{
			return createdObjType;
		}

		@Override
		public void Dispose()
		{
			super.Dispose();
		}

		protected void SetObject(Object obj)
		{
			this.createdObj = (T) obj;

			creationHandler.onCreationHandle(this);
		}

		@Override
		public boolean BeginCreation()
		{
			return this.Open();
		}

		@Override
		public T Return()
		{
			return createdObj;
		}

		@Override
		public boolean HasCreationHandler()
		{
			return creationHandler != null;
		}

		@Override
		public ICreationHandler<T> GetCreationHandler()
		{
			return creationHandler;
		}

		@Override
		public boolean SetCreationHandler(ICreationHandler<T> creationHandler)
		{
			this.creationHandler = creationHandler;

			return true;
		}
	}

	public static class ConstructorChooseSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends ConstructorChooseSite.ConstructorChooseSiteSession>
			extends InventoryDefaultPagedSite<TParam, TSession>
	{
		public static class ConstructorChooseSiteSession extends InventoryPagedSiteSession
		{
			protected static ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ConstructorChooseSiteSession> sessionFactory = new ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ConstructorChooseSiteSession>()
			{
				@SuppressWarnings({ "unchecked", "rawtypes" })
				public ConstructorChooseSiteSession CreateSession(
						InventoryDataContainer<? extends MenuConstInventoryDataContainer> parameter)
				{
					Class<?> clazz = (Class<?>) parameter.GetConstantData().GetExternalData("creationClazz");

					return new ConstructorChooseSiteSession(clazz.getDeclaredConstructors());
				}
			};

			Constructor<?>[] constructors;
			ItemStack[] convertedConstructors;
			int selectedElement;

			public ConstructorChooseSiteSession(Constructor<?>[] constructors)
			{
				this.constructors = constructors;

				convertedConstructors = new ItemStack[constructors.length];

				for (int i = 0; i < constructors.length; i++)
				{
					convertedConstructors[i] = ConstructorToIS(constructors[i]);
				}
			}

			protected ItemStack ConstructorToIS(Constructor<?> c)
			{
				return new ItemStack(Material.ANVIL);
			}

			public Constructor<?> GetSelectedConstructor()
			{
				if (0 <= selectedElement
						&& selectedElement < constructors.length) { return constructors[selectedElement]; }

				return null;
			}
		}

		public ConstructorChooseSite(String title, int size,
				ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
		{
			super(title, size, sessionFactory);
			
			subSites.put(0, ParameterChooseSite.Init("Parameter Choose TEST", 54));
		}

		public static ConstructorChooseSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ConstructorChooseSiteSession> Init(
				String title, int size)
		{
			return new ConstructorChooseSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ConstructorChooseSiteSession>(
					title, size, ConstructorChooseSiteSession.sessionFactory);
		}
		
		@Override
		protected boolean BackToSuperSiteSession(ISiteSession caller, TParam extData, TSession siteSession)
		{
			((CreationMenuSession<Object>)extData.GetConstantData().GetInventorySession()).CallError(-3);
			
			return true;
		}

		@Override
		public ItemStack[] GetElements(TSession siteSession)
		{
			return siteSession.convertedConstructors;
		}

		@Override
		public ItemStack GetElement(TSession siteSession, int index)
		{
			return 0 <= index && index < siteSession.constructors.length ? siteSession.convertedConstructors[index]
					: null;
		}

		@Override
		public int GetElementsAmount(TSession siteSession)
		{
			return siteSession.convertedConstructors.length;
		}

		@Override
		public boolean OnElementClick(int clickedElementIndex, ISiteSession caller, TParam extData, TSession siteSession)
		{
			siteSession.selectedElement = clickedElementIndex;
			
			extData.GetConstantData().SetExternalData("selectedConstructor", siteSession.GetSelectedConstructor());
			
			return siteSession.SetActiveSubSiteSessionID(0);
		}
	}

	public static class ParameterChooseSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends ParameterChooseSite.ParameterChooseSiteSession>
			extends InventoryDefaultPagedSite<TParam, TSession>
	{
		private static final ItemStack DONE = ISBuilder.CreateIS(Material.NETHER_STAR).SetName(ChatColor.GOLD + "Finish creation!").GetResult();
		
		public static class ParameterChooseSiteSession extends InventoryPagedSiteSession
				implements ICreationHandler<Object>
		{
			protected static ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ParameterChooseSiteSession> sessionFactory = new ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ParameterChooseSiteSession>()
			{
				public ParameterChooseSiteSession CreateSession(
						InventoryDataContainer<? extends MenuConstInventoryDataContainer> parameter)
				{
					Constructor<?> c = (Constructor<?>) parameter.GetConstantData()
							.GetExternalData("selectedConstructor");

					return new ParameterChooseSiteSession(c);
				}
			};

			Constructor<?> constructor;
			Class<?>[] parameters;
			ItemStack[] convertedParameters;
			Object[] createdParameters;
			int selectedParameter = -1;

			CreationModule<?> paramCreationModule;

			public ParameterChooseSiteSession(Constructor<?> constructor)
			{
				this.constructor = constructor;
				this.parameters = constructor.getParameterTypes();

				convertedParameters = new ItemStack[parameters.length];
				createdParameters = new Object[parameters.length];

				for (int i = 0; i < parameters.length; i++)
				{
					convertedParameters[i] = ParameterToIS(parameters[i]);
				}
			}

			protected ItemStack ParameterToIS(Class<?> clazz)
			{
				return new ItemStack(Material.APPLE);
			}

			public Class<?> GetParameter(int index)
			{
				return 0 <= index && index < parameters.length ? parameters[index] : null;
			}

			public Class<?> GetSelectedParameter()
			{
				return GetParameter(selectedParameter);
			}

			public ItemStack GetConvertedParameter(int index)
			{
				return 0 <= index && index < parameters.length ? convertedParameters[index] : null;
			}

			public ItemStack GetSelectedConvertedParameter()
			{
				return GetConvertedParameter(selectedParameter);
			}
			
			public Object Create()
			{
				try
				{
					constructor.setAccessible(true);
					
					return constructor.newInstance(createdParameters);
				}
				catch (InstantiationException | IllegalAccessException | IllegalArgumentException
						| InvocationTargetException e)
				{
					
				}
				
				return null;
			}

			@Override
			public void onCreationHandle(ICreationInterface<Object> creationInterface)
			{
				createdParameters[selectedParameter] = creationInterface.Return();

				selectedParameter = -1;
			}

			@Override
			public void onErrorHandle(ICreationInterface<Object> creationInterface, int code)
			{
				selectedParameter = -1;
			}
		}

		public ParameterChooseSite(String title, int size,
				ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
		{
			super(title, size, sessionFactory);
			
			this.staticContent[size - 4] = DONE.clone();
			this.staticContent[size - 6] = DONE.clone();
		}
		
		public static ParameterChooseSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ParameterChooseSiteSession> Init(
				String title, int size)
		{
			return new ParameterChooseSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ParameterChooseSiteSession>(
					title, size, ParameterChooseSiteSession.sessionFactory);
		}

		@Override
		public ItemStack[] GetElements(TSession siteSession)
		{
			return siteSession.convertedParameters;
		}

		@Override
		public ItemStack GetElement(TSession siteSession, int index)
		{
			return siteSession.GetConvertedParameter(index);
		}

		@Override
		public int GetElementsAmount(TSession siteSession)
		{
			return siteSession.convertedParameters.length;
		}
		
		@SuppressWarnings("unchecked")
		@Override
		public boolean OnInventoryClick(InventoryClickEvent ev, ISiteSession caller, TParam extData, TSession siteSession)
		{
			int size = this.GetContainerSize(siteSession);
			
			if(ev.getRawSlot() == size - 4 || ev.getRawSlot() == size - 6)
			{		
				Object obj;
				
				try
				{
					obj = siteSession.Create();
				}
				catch (IllegalArgumentException e)
				{
					((CreationMenuSession<?>)extData.GetConstantData().GetInventorySession()).CallError(2);
					
					return false;
				}
				
				((CreationMenuSession<Object>)extData.GetConstantData().GetInventorySession()).SetObject(obj);
				
				extData.GetConstantData().DisposeSession();
				
				return false;
				
			}
			
			return super.OnInventoryClick(ev, caller, extData, siteSession);
		}


		@SuppressWarnings({ "rawtypes", "unchecked" })
		@Override
		public boolean OnElementClick(int clickedElementIndex, ISiteSession caller, TParam extData, TSession siteSession)
		{
			siteSession.selectedParameter = clickedElementIndex;

			ICreationHandler<Object> creationHandler = new ICreationHandler<Object>()
			{				
				@Override
				public void onCreationHandle(ICreationInterface<Object> creationInterface)
				{
					siteSession.createdParameters[siteSession.selectedParameter] = creationInterface.Return();
					
					siteSession.selectedParameter = -1;
					extData.GetConstantData().GetInventorySession().Open();
				}

				@Override
				public void onErrorHandle(ICreationInterface<Object> creationInterface, int code)
				{
					siteSession.selectedParameter = -1;
					extData.GetConstantData().GetInventorySession().Open();
				}
			};

			siteSession.paramCreationModule = CreationModule.Create(extData.GetOwner(),
					(Class) siteSession.GetSelectedParameter(), creationHandler);
			siteSession.paramCreationModule.BeginCreation();
			
			return false;
		}
	}

	public CreationMenu()
	{
		super(ConstructorChooseSite.Init("Constructor Choose TEST", 54));
	}
}
