package an0nym8us.bukkit.magicCrafting.menu;

import java.util.Map;
import java.util.Map.Entry;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.altar.IPresentable;
import an0nym8us.bukkit.magicCrafting.altar.IRecipe;
import an0nym8us.bukkit.magicCrafting.managers.IIDRecipeManager;
import an0nym8us.bukkit.magicCrafting.menu.AdminMenu.RecipeCreatorSite.RecipeCreatorSiteSession;
import an0nym8us.processorSession.InventoryPagedSiteSession;
import an0nym8us.processorSession.InventorySite;
import an0nym8us.processorSession.InventorySiteSession;
import an0nym8us.processorSession.Site;
import an0nym8us.processorSession.SiteSession;
import an0nym8us.processorSession.data.InventoryDataContainer;
import an0nym8us.processorSession.site.ISite;
import an0nym8us.processorSession.site.ISiteSession;
import an0nym8us.processorSession.struct.ISessionFactory;
import an0nym8us.utils.menu.InventoryDefaultPagedSite;
import an0nym8us.utils.menu.MenuConstInventoryDataContainer;
import an0nym8us.utils.menu.SiteMenu;

public class AdminMenu extends
		SiteMenu<AdminMenu.MainSite<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, InventorySiteSession>, InventorySiteSession>
{
	public static class MainSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends InventorySiteSession>
			extends InventorySite<TParam, TSession>
	{
		private static ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, InventorySiteSession> sessionFactory = new ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, InventorySiteSession>()
		{
			@SuppressWarnings({ "unchecked", "rawtypes" })
			public InventorySiteSession CreateSession(
					InventoryDataContainer<? extends MenuConstInventoryDataContainer> parameter)
			{
				return new InventorySiteSession();
			}
		};
		
		private static final int RECIPE_INDEX = 0;

		protected MainSite(int size, ISessionFactory<? super TParam, ? extends TSession> sessionFactory,
				ISite<TParam, ?>... sites)
		{
			super("Main Site TEST", PrepareContent(size), sessionFactory);

			for (int i = 0; i < sites.length; i++)
			{
				this.subSites.put(i, sites[i]);
			}
		}

		public static <TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>> MainSite<? super TParam, InventorySiteSession> Create(
				int size, ISite<TParam, ?>... sites)
		{
			return new MainSite<TParam, InventorySiteSession>(size, sessionFactory, sites);
		}

		protected static ItemStack[] PrepareContent(int size)
		{
			ItemStack[] res = new ItemStack[size];

			for (int i = 0; i < size; i++)
			{
				res[i] = new ItemStack(Material.AIR);
			}

			res[RECIPE_INDEX] = new ItemStack(Material.ANVIL);

			return res;
		}

		@Override
		public boolean OnInventoryClick(InventoryClickEvent ev, ISiteSession caller, TParam extData, TSession siteSession)
		{
			Bukkit.getLogger().info("?");

			if (ev.getRawSlot() == RECIPE_INDEX)
			{
				Bukkit.getLogger().info("jumping...");

				Bukkit.getLogger().info("jumped!");
				
				return siteSession.SetActiveSubSiteSessionID(0);
			}
			
			return false;
		}
	}

	public static class RecipeListSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends RecipeListSite.RecipeListSiteSession>
			extends InventoryDefaultPagedSite<TParam, TSession>
	{
		private static ISessionFactory<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ? extends RecipeListSite.RecipeListSiteSession> sessionFactory = new ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, RecipeListSite.RecipeListSiteSession>()
		{
			@SuppressWarnings({ "unchecked", "rawtypes" })
			public RecipeListSite.RecipeListSiteSession CreateSession(
					InventoryDataContainer<? extends MenuConstInventoryDataContainer> parameter)
			{
				return new RecipeListSite.RecipeListSiteSession(Main.GetInstance().GetRecipeManager());
			}
		};

		public static class ActionChoiceSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends InventorySiteSession>
				extends InventorySite<TParam, TSession>
		{
			private static ISessionFactory<? super InventoryDataContainer<? extends MenuConstInventoryDataContainer>, ? extends InventorySiteSession> sessionFactory = new ISessionFactory<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, InventorySiteSession>()
			{
				@SuppressWarnings({ "unchecked", "rawtypes" })
				public InventorySiteSession CreateSession(
						InventoryDataContainer<? extends MenuConstInventoryDataContainer> parameter)
				{
					return new InventorySiteSession();
				}
			};

			private static final ItemStack MODIFY_ITEM = ISBuilder.CreateIS(Material.ANVIL).SetName("MODIFY")
					.GetResult();
			private static final ItemStack REMOVE_ITEM = ISBuilder.CreateIS(Material.BARRIER).SetName("REMOVE")
					.GetResult();

			public ActionChoiceSite(String title, int size,
					ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
			{
				super(title, PrepareContent(size), sessionFactory);
			}

			public static ActionChoiceSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, InventorySiteSession> Create(
					String title, int size)
			{
				return new ActionChoiceSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, InventorySiteSession>(
						title, size, sessionFactory);
			}

			protected static ItemStack[] PrepareContent(int size)
			{
				ItemStack[] res = ISBuilder.PrepareEmptyArray(size);

				res[0] = MODIFY_ITEM.clone();
				res[1] = REMOVE_ITEM.clone();

				return res;
			}

			@Override
			public boolean OnInventoryClick(InventoryClickEvent ev, ISiteSession caller, TParam extData,
					TSession siteSession)
			{
				if (ev.getRawSlot() == 0)
				{
					Bukkit.getLogger().info("modify");
				}
				else if (ev.getRawSlot() == 1)
				{
					Bukkit.getLogger().info("remove");

					return ((RecipeListSiteSession) caller).RemoveSelectedRecipe();
					//Bukkit.getLogger().info(((RecipeListSiteSession) caller).RemoveSelectedRecipe() ? "true" : "false");
				}

				Bukkit.getLogger().info("back");

				return caller.UnsetActiveSubSiteSession();
			}
		}

		public static class RecipeListSiteSession extends InventoryPagedSiteSession
		{
			private IIDRecipeManager<Integer, ?, ?> recipeManager;

			Integer[] recipeIDs;
			ItemStack[] recipeISs;

			int selectedIndex = -1;

			public RecipeListSiteSession(IIDRecipeManager<Integer, ?, ?> recipeManager)
			{
				this.recipeManager = recipeManager;

				UpdateRecipeIds();
			}

			public ItemStack[] GetRecipeISs()
			{
				return recipeISs;
			}

			public int GetRecipeISsAmount()
			{
				return recipeISs.length;
			}

			public ItemStack GetRecipeIS(int index)
			{
				if (0 <= index && index < recipeISs.length) { return recipeISs[index]; }

				return null;
			}

			public int GetSelectedIndex()
			{
				return selectedIndex;
			}

			public void SetSelectedIndex(int index)
			{
				this.selectedIndex = index;
			}

			public Integer[] GetRecipeIDs()
			{
				return recipeIDs;
			}

			public boolean RemoveSelectedRecipe()
			{
				return recipeManager.DeleteRecipe(recipeIDs[selectedIndex]);
			}

			public void UpdateRecipeIds()
			{
				long dump = System.currentTimeMillis();
				Bukkit.getLogger().info("-----------------------");
				Bukkit.getLogger().info("Dump: 0ms");
				IIDRecipeManager<Integer, ?, ?> mng = recipeManager;

				@SuppressWarnings("unchecked")
				Map<Integer, IRecipe<?, ?>> map = (Map<Integer, IRecipe<?, ?>>) ((Map<Integer, ?>) mng.GetRecipeMap());

				long dump1 = System.currentTimeMillis();
				Bukkit.getLogger().info("Recipe received in: " + (dump1 - dump) + "ms");
				recipeIDs = new Integer[map.size()];
				recipeISs = new ItemStack[recipeIDs.length];

				int i = 0;
				for (Entry<Integer, IRecipe<?, ?>> en : map.entrySet())
				{
					recipeIDs[i] = en.getKey();

					IRecipe<?, ?> recipe = en.getValue();

					if (recipe instanceof IPresentable)
					{
						recipeISs[i] = ((IPresentable) recipe).GetPresentationIS();
					}
					else if (true)
					{
						recipeISs[i] = AdminMenu.GetImpresentable(recipe);
					}

					i++;
				}

				long dump2 = System.currentTimeMillis();
				Bukkit.getLogger().info("Recipe processed in: " + (dump2 - dump1) + "ms");
				Bukkit.getLogger().info("Total time: " + (dump2 - dump1) + "ms");
				Bukkit.getLogger().info("-----------------------");
			}
		}

		protected RecipeListSite(int size, ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
		{
			super("Recipe List TEST", size, sessionFactory);

			subSites.put(0, ActionChoiceSite.Create("Action Choice TEST", 54));
		}

		public static RecipeListSite<InventoryDataContainer<? extends MenuConstInventoryDataContainer>, RecipeListSite.RecipeListSiteSession> Create(
				int size)
		{
			return new RecipeListSite<>(size, sessionFactory);
		}

		@Override
		public ItemStack[] GetContent(TSession siteSession)
		{
			siteSession.UpdateRecipeIds();

			return super.GetContent(siteSession);
		}

		@Override
		public ItemStack[] GetElements(TSession siteSession)
		{
			return siteSession.GetRecipeISs();
		}

		@Override
		public ItemStack GetElement(TSession siteSession, int index)
		{
			return siteSession.GetRecipeIS(index);
		}

		@Override
		public int GetElementsAmount(TSession siteSession)
		{
			return siteSession.GetRecipeISsAmount();
		}

		@Override
		public Integer[] GetElementMap(TSession siteSession)
		{
			return elementMap;
		}

		@Override
		public boolean OnElementClick(int clickedElementIndex, ISiteSession caller, TParam extData, TSession siteSession)
		{
			siteSession.selectedIndex = clickedElementIndex;

			return siteSession.UnsetActiveSubSiteSession();

			//Bukkit.getLogger().info("Element touched!");
		}
	}

	public static class RecipeCreatorSite<TParam extends InventoryDataContainer<? extends MenuConstInventoryDataContainer>, TSession extends RecipeCreatorSiteSession>
			extends Site<TParam, TSession>
	{
		public RecipeCreatorSite(ISessionFactory<? super TParam, ? extends TSession> sessionFactory)
		{
			super(sessionFactory);
			// TODO Auto-generated constructor stub
		}

		public static class RecipeCreatorSiteSession extends SiteSession
		{

		}

		@Override
		public boolean Update(TParam param, TSession session)
		{
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean ProcessThis(ISiteSession caller, TParam extData, TSession session)
		{
			// TODO Auto-generated method stub
			return false;
		}
	}

	public AdminMenu()
	{
		super(MainSite.Create(54, RecipeListSite.Create(54)));
	}

	protected static ItemStack GetImpresentable(IRecipe<?, ?> ar)
	{
		return IMPRESENTABLE_RECIPE.clone();
	}
}
