package an0nym8us.bukkit.magicCrafting.managers;

import java.util.HashMap;
import java.util.Map;

import an0nym8us.bukkit.magicCrafting.altar.IRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeInput;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeOutput;

public class TestRecipeManager extends DefaultRecipeManager<ItemAltarRecipeInput>
		implements IIDRecipeManager<Integer, ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	public TestRecipeManager(boolean loadMinecraftRecipes)
	{
		super(loadMinecraftRecipes);
	}

	@Override
	public boolean DeleteRecipe(Integer id)
	{
		return defaultRecipes.remove((int) id) != null;
	}

	@Override
	public Integer AddIDedRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> recipe)
	{
		defaultRecipes.add(recipe);

		return defaultRecipes.size() - 1;
	}

	@Override
	public IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> GetRecipeByID(Integer id)
	{
		return defaultRecipes.get(id);
	}

	@Override
	public Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> GetRecipeMap()
	{
		Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> res = new HashMap<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>();

		int i = 0;
		for (IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> r : defaultRecipes)
		{
			res.put(i++, r);
		}

		return res;
	}
}
