package an0nym8us.bukkit.magicCrafting.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.Location;

import an0nym8us.bukkit.magicCrafting.IDisposable;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.altar.IStructure;
import an0nym8us.bukkit.magicCrafting.altar.ITickable;

public class StructureManager implements IDisposable
{
	List<IStructure> structures;

	Runnable task;
	int taskID;

	boolean isDisposed;

	public StructureManager()
	{
		structures = new ArrayList<IStructure>();

		task = new Runnable()
		{
			@Override
			public void run()
			{
				synchronized (structures)
				{
					for (IStructure as : structures)
					{
						if (as.IsDisposed() || !(as instanceof ITickable))
						{
							continue;
						}

						((ITickable) as).Tick();
					}
				}
			}
		};

		taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask(Main.GetInstance(), task, 4, 4);
	}

	public void AddStructure(IStructure structure)
	{
		if (structure == null) { return; }
		
		structures.add(structure);
	}

	public void RemoveStructure(IStructure structure)
	{
		if (structure == null) { return; }
		
		if (!structure.IsDisposed())
		{
			structure.Dispose();
		}

		structures.remove(structure);
	}

	public List<IStructure> GetStructures(UUID owner)
	{
		List<IStructure> res = new ArrayList<IStructure>();

		for (IStructure struct : structures)
		{
			if (struct.HasOwner() && struct.GetOwner().equals(owner))
			{
				res.add(struct);
			}
		}

		return res;
	}

	public IStructure GetStructure(Location loc)
	{
		for (IStructure struct : structures)
		{
			if (struct.DoesBelong(loc)) { return struct; }
		}

		return null;
	}

	public boolean StructureExists(Location loc)
	{
		for (IStructure struct : structures)
		{
			if (struct.DoesBelong(loc)) { return true; }
		}

		return false;
	}

	/** LMulti-Related structures are not supported though **/
	public List<IStructure> GetStructures(Location loc)
	{
		List<IStructure> res = new ArrayList<IStructure>();

		for (IStructure struct : structures)
		{
			if (struct.DoesBelong(loc))
			{
				res.add(struct);
			}
		}

		return res;
	}

	public void DisposeStructures()
	{
		while (structures.size() != 0)
		{
			RemoveStructure(structures.get(0));
		}
	}

	public void Dispose()
	{
		DisposeStructures();

		Bukkit.getScheduler().cancelTask(taskID);

		isDisposed = true;
	}

	@Override
	public boolean IsDisposed()
	{
		return isDisposed;
	}
}
