package an0nym8us.bukkit.magicCrafting.managers;

import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.SerializationProvider;
import an0nym8us.bukkit.magicCrafting.altar.IRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeInput;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeOutput;
import an0nym8us.bukkit.magicCrafting.mysql.MySQL;

public class SQLRecipeManager extends PreloadedRecipeManager
{
	MySQL connection;

	public SQLRecipeManager(boolean loadMinecraftRecipes, Plugin plugin, String hostname, int port, String database,
			String username, String password) throws SQLException
	{
		super(loadMinecraftRecipes);

		connection = new MySQL(plugin, hostname, port, database, username, password);
	}

	@Override
	public boolean LoadRecipes()
	{
		this.recipes = LoadRecipeMap(new HashMap<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>());

		return recipes != null;
	}

	@Override
	public boolean SaveRecipes()
	{
		// Saving is not supported here!
		
		return false;
	}

	protected Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> LoadRecipeMap(Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> map)
	{
		Statement s = null;
		ResultSet rs = null;

		try
		{
			s = connection.GetConnection().createStatement();

			rs = s.executeQuery("SELECT * FROM " + MySQL.RECIPE_TABLE);

			while (rs.next())
			{
				try
				{
					@SuppressWarnings("unchecked")
					IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar = (IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>) SerializationProvider
							.Deserialize(rs.getBytes(MySQL.OBJ_COL_NAME));

					map.put(rs.getInt(MySQL.ID_COL_NAME), ar);
				}
				catch (ClassNotFoundException ex)
				{
					Bukkit.getLogger().warning("Recipe class not found: " + ex.getMessage());
				}
				catch (IOException ex)
				{
					Bukkit.getLogger().warning("Corrupted recipe, ID: " + rs.getInt(MySQL.ID_COL_NAME)
							+ ". It will not affect gameplay, however it's useless.");
				}
				catch (Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}
		catch (SQLException ex)
		{
			Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}

				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return map;
	}

	@Override
	public List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> GetRecipes()
	{
		List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> res = null;

		Statement s = null;
		ResultSet rs = null;

		try
		{
			s = connection.GetConnection().createStatement();

			rs = s.executeQuery("SELECT * FROM " + MySQL.RECIPE_TABLE);

			res = new ArrayList<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>();

			while (rs.next())
			{
				try
				{
					@SuppressWarnings("unchecked")
					IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar = (IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>) SerializationProvider
							.Deserialize(rs.getBytes(MySQL.OBJ_COL_NAME));

					res.add(ar);
				}
				catch (ClassNotFoundException ex)
				{
					Bukkit.getLogger().warning("Recipe class not found: " + ex.getMessage());
				}
				catch (IOException ex)
				{
					Bukkit.getLogger().warning("Corrupted recipe, ID: " + rs.getInt(MySQL.ID_COL_NAME)
							+ ". It will not affect gameplay, however it's useless.");
				}
				catch (Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}
		catch (SQLException ex)
		{
			Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}

				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return res;
	}

	@Override
	public boolean AddRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar)
	{
		if (!(ar instanceof Serializable)) { return false; }

		Bukkit.getScheduler().runTaskAsynchronously(Main.GetInstance(), new Runnable()
		{
			public void run()
			{
				PreparedStatement ps = null;

				try
				{
					synchronized (connection)
					{
						connection.LockRecipeTable();

						ps = connection.GetConnection().prepareStatement(
								"INSERT INTO " + MySQL.RECIPE_TABLE + " (" + MySQL.OBJ_COL_NAME + ") VALUES (?)", Statement.RETURN_GENERATED_KEYS);
						ps.setBytes(1, SerializationProvider.Serialize(ar));

						ResultSet rs = ps.getGeneratedKeys();
						
						if(!rs.next())
						{
							return;
						}
						
						SQLRecipeManager.this.recipes.put(rs.getInt(1), ar);
						
						rs.close();
						
						ps.execute();
					}
				}
				catch (SQLException ex)
				{
					Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
				}
				catch (IOException ex)
				{
					Bukkit.getLogger().warning("Recipe serialization failed, replacement aborted.");

					ex.printStackTrace();
				}
				finally
				{
					try
					{
						if (ps != null)
						{
							ps.close();
						}
					}
					catch (SQLException e)
					{
						e.printStackTrace();
					}
				}
			}
		});

		return true;
	}

	@Override
	public boolean DeleteRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar)
	{
		if (!recipes.containsValue(ar)) { return false; }

		for (Entry<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> en : recipes.entrySet())
		{
			if (en.getValue().equals(ar))
			{
				recipes.remove(en.getKey());

				final Integer ID = en.getKey();

				if (super.DeleteRecipe(ID)) { return false; }

				Bukkit.getScheduler().runTaskAsynchronously(Main.GetInstance(), new Runnable()
				{
					public void run()
					{
						synchronized (connection)
						{
							PreparedStatement ps = null;
							Statement s = null;
							ResultSet rs = null;

							try
							{
								if (!connection.LockRecipeTable()) { return; }

								ps = connection.GetConnection().prepareStatement(
										"DELETE FROM " + MySQL.RECIPE_TABLE + " WHERE " + MySQL.ID_COL_NAME + "=?");

								ps.setLong(1, ID);

								ps.execute();
								/*
								 * } else { s =
								 * connection.GetConnection().createStatement();
								 * 
								 * rs = s.executeQuery("SELECT * FROM " +
								 * MySQL.RECIPE_TABLE);
								 * 
								 * while (rs.next()) { try { AltarRecipe buff =
								 * (AltarRecipe) SerializationProvider
								 * .Deserialize(rs.getBytes(MySQL.OBJ_COL_NAME))
								 * ;
								 * 
								 * if (buff.equals(ar)) { rs.close(); s.close();
								 * 
								 * rs = null; s = null;
								 * 
								 * ps =
								 * connection.GetConnection().prepareStatement(
								 * "DELETE FROM " + MySQL.RECIPE_TABLE +
								 * " WHERE " + MySQL.ID_COL_NAME + "=?");
								 * 
								 * ps.setLong(1, buff.GetID());
								 * 
								 * ps.execute();
								 * 
								 * return; } } catch (ClassNotFoundException ex)
								 * { Bukkit.getLogger().warning(
								 * "Recipe class not found: " +
								 * ex.getMessage()); } catch (IOException ex) {
								 * Bukkit.getLogger().warning(
								 * "Corrupted recipe, ID: " +
								 * rs.getInt(MySQL.ID_COL_NAME) +
								 * ". It will not affect gameplay, however it's useless."
								 * ); } catch (Exception ex) {
								 * ex.printStackTrace(); } }
								 */

								connection.UnlockTables();

								return;
							}
							catch (SQLException ex)
							{
								Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
							}
							finally
							{
								try
								{
									if (ps != null)
									{
										ps.close();
									}

									if (rs != null)
									{
										rs.close();
									}

									if (s != null)
									{
										s.close();
									}
								}
								catch (SQLException e)
								{
									e.printStackTrace();
								}
							}
						}
					}
				});

				return true;
			}
		}

		return false;
	}

	public boolean DeleteRecipe(Integer id)
	{
		PreparedStatement ps = null;

		try
		{
			ps = connection.GetConnection()
					.prepareStatement("DELETE FROM " + MySQL.RECIPE_TABLE + " WHERE " + MySQL.ID_COL_NAME + "=?");

			ps.setLong(1, id);

			return ps.executeUpdate() > 0;
		}
		catch (SQLException ex)
		{
			Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
		}
		finally
		{
			try
			{
				if (ps != null)
				{
					ps.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return false;
	}

	@Override
	public boolean ReplaceRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> oldRecipe, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> newRecipe)
	{
		if (!(newRecipe instanceof Serializable)) { return false; }

		if (!recipes.containsValue(newRecipe)) { return false; }

		for (Entry<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> en : recipes.entrySet())
		{
			if (en.getValue().equals(oldRecipe))
			{
				Bukkit.getScheduler().runTaskAsynchronously(Main.GetInstance(), new Runnable()
				{
					public void run()
					{
						synchronized (connection)
						{
							PreparedStatement ps = null;
							Statement s = null;
							ResultSet rs = null;

							try
							{
								if (!connection.LockRecipeTable()) { return; }

								byte[] data = null;

								try
								{
									data = SerializationProvider.Serialize(newRecipe);
								}
								catch (IOException ex)
								{
									Bukkit.getLogger().warning("Recipe serialization failed, replacement aborted.");

									ex.printStackTrace();

									return;
								}

								ps = connection.GetConnection().prepareStatement("UPDATE " + MySQL.RECIPE_TABLE
										+ " SET " + MySQL.OBJ_COL_NAME + "=? WHERE " + MySQL.ID_COL_NAME + "=?");

								ps.setBytes(1, data);
								ps.setLong(2, en.getKey());

								ps.execute();

								/*
								 * else { s =
								 * connection.GetConnection().createStatement();
								 * 
								 * rs = s.executeQuery("SELECT * FROM " +
								 * MySQL.RECIPE_TABLE);
								 * 
								 * while (rs.next()) { try { AltarRecipe buff =
								 * (AltarRecipe) SerializationProvider
								 * .Deserialize(rs.getBytes(MySQL.OBJ_COL_NAME))
								 * ;
								 * 
								 * if (buff.equals(oldRecipe)) { rs.close();
								 * s.close();
								 * 
								 * rs = null; s = null;
								 * 
								 * ps =
								 * connection.GetConnection().prepareStatement(
								 * "UPDATE " + MySQL.RECIPE_TABLE + " SET " +
								 * MySQL.OBJ_COL_NAME + "=? WHERE " +
								 * MySQL.ID_COL_NAME + "=?");
								 * 
								 * ps.setBytes(1,
								 * SerializationProvider.Serialize(newRecipe));
								 * ps.setLong(2, buff.GetID());
								 * 
								 * ps.execute();
								 * 
								 * return; } } catch (ClassNotFoundException ex)
								 * { Bukkit.getLogger().warning(
								 * "Recipe class not found: " +
								 * ex.getMessage()); } catch (IOException ex) {
								 * Bukkit.getLogger().warning(
								 * "Corrupted recipe, ID: " +
								 * rs.getInt(MySQL.ID_COL_NAME) +
								 * ". It will not affect gameplay, however it's useless."
								 * ); } catch (Exception ex) {
								 * ex.printStackTrace(); } }
								 * 
								 * connection.UnlockTables();
								 * 
								 * return; }
								 */

								return;
							}
							catch (SQLException ex)
							{
								Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
							}
							finally
							{
								try
								{
									if (ps != null)
									{
										ps.close();
									}

									if (rs != null)
									{
										rs.close();
									}

									if (s != null)
									{
										s.close();
									}
								}
								catch (SQLException e)
								{
									e.printStackTrace();
								}
							}
						}
					}
				});
			}
		}

		return false;
	}

	public int GetRecipeAmount()
	{
		Statement s = null;
		ResultSet rs = null;

		try
		{
			s = connection.GetConnection().createStatement();

			rs = s.executeQuery("SELECT COUNT(*) FROM " + MySQL.RECIPE_TABLE);

			rs.next();

			return rs.getInt(1);
		}
		catch (SQLException ex)
		{
			Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}

				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return -1;
	}

	@SuppressWarnings("unchecked")
	public IRecipe<? super ItemAltarRecipeInput, ?> GetRecipeByIndex(int index)
	{
		IRecipe<? super ItemAltarRecipeInput, ?> res = null;

		Statement s = null;
		ResultSet rs = null;

		try
		{
			s = connection.GetConnection().createStatement();

			rs = s.executeQuery("SELECT * FROM " + MySQL.RECIPE_TABLE);

			for (int i = -1; i < index; i++)
			{
				if (!rs.next()) { return null; }
			}

			try
			{
				return (IRecipe<? super ItemAltarRecipeInput, ?>) SerializationProvider.Deserialize(rs.getBytes(MySQL.OBJ_COL_NAME));
			}
			catch (ClassNotFoundException ex)
			{
				Bukkit.getLogger().warning("Recipe class not found: " + ex.getMessage());
			}
			catch (IOException ex)
			{
				Bukkit.getLogger().warning("Corrupted recipe, ID: " + rs.getInt(MySQL.ID_COL_NAME)
						+ ". It will not affect gameplay, however it's useless.");
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
		catch (SQLException ex)
		{
			Bukkit.getLogger().warning("Database connection error: " + ex.getMessage());
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
				}

				if (s != null)
				{
					s.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}

		return res;
	}

	@Override
	public void Dispose()
	{
		connection.Dispose();
	}
}
