package an0nym8us.bukkit.magicCrafting.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import an0nym8us.bukkit.magicCrafting.MultiIterator;
import an0nym8us.bukkit.magicCrafting.SerializationInputStream;
import an0nym8us.bukkit.magicCrafting.SerializationOutputStream;
import an0nym8us.bukkit.magicCrafting.altar.IRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeInput;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeOutput;

public abstract class PreloadedRecipeManager extends DefaultRecipeManager<ItemAltarRecipeInput> implements IIDRecipeManager<Integer, ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	Integer idCounter = 0;
	Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> recipes;

	public PreloadedRecipeManager(boolean loadMinecraftRecipes)
	{
		super(loadMinecraftRecipes);
	}

	public abstract boolean LoadRecipes();

	public abstract boolean SaveRecipes();

	public boolean DeleteRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar)
	{
		if (recipes.containsValue(ar))
		{
			for (Entry<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> en : recipes.entrySet())
			{
				if (en.getValue().equals(ar))
				{
					recipes.remove(en.getKey());

					return true;
				}
			}
		}
		
		return super.DeleteRecipe(ar);
	}
	
	@Override
	public boolean DeleteRecipe(Integer id)
	{
		if (recipes.containsKey(id))
		{
			recipes.remove(id);

			return true;
		}

		return false;
	}

	public boolean AddRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar)
	{
		if (!(ar instanceof Serializable)) { return super.AddRecipe(ar); }

		recipes.put(idCounter++, ar);

		return true;
	}

	public boolean ReplaceRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> oldRecipe, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> newRecipe)
	{
		if (!recipes.containsKey(oldRecipe) || !(newRecipe instanceof Serializable)) { return false; }

		for (Entry<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> en : recipes.entrySet())
		{
			if (en.getValue().hashCode() == oldRecipe.hashCode() && en.getValue().equals(oldRecipe))
			{
				recipes.put(en.getKey(), newRecipe);

				return true;
			}
		}

		return super.ReplaceRecipe(oldRecipe, newRecipe);
	}
	
	public int GetRecipeAmount()
	{
		return recipes.size() + super.GetRecipeAmount();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Iterator<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> iterator()
	{
		return new MultiIterator<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>(new Iterator[] {super.iterator(), recipes.values().iterator()});
	}

	public Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> GetRecipeMap()
	{
		return recipes;
	}
	
	@Override
	public List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> GetRecipes()
	{
		List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> res = new ArrayList<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>();

		res.addAll(recipes.values());

		res.addAll(super.GetRecipes());
		
		return res;
	}

	public IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> GetRecipeById(int id)
	{
		if (recipes.size() > id)
		{
			IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> res = recipes.get(id);

			return res;
		}

		return null;
	}

	@Override
	public IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> GetFirstMatchingRecipe(ItemAltarRecipeInput input)
	{
		for (int i = 0; i < recipes.size(); i++)
		{
			try
			{
				IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar = recipes.get(i);

				if (ar.DoesMatch(input)) { return ar; }
			}
			catch (ClassCastException ex)
			{
				continue;
			}
		}

		return super.GetFirstMatchingRecipe(input);
	}

	public List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> GetMatchingRecipes(ItemAltarRecipeInput input)
	{
		List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> res = new ArrayList<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>();

		for (int i = 0; i < recipes.size(); i++)
		{
			try
			{
				IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> ar = recipes.get(i);

				if (ar.DoesMatch(input))
				{
					res.add(ar);
				}
			}
			catch (ClassCastException ex)
			{
				continue;
			}
		}

		res.addAll(super.GetMatchingRecipes(input));

		return res;
	}

	protected static void SerializeToFile(File file, int idCounter, Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> list)
			throws IOException
	{
		FileOutputStream fos = new FileOutputStream(file);
		SerializationOutputStream oos = new SerializationOutputStream(fos);

		oos.writeInt(idCounter);
		oos.writeObject(list);

		oos.close();
		fos.close();
	}

	@SuppressWarnings("unchecked")
	protected void DeserializeFromFile(File file) throws IOException
	{
		try
		{
			FileInputStream fis = new FileInputStream(file);
			SerializationInputStream ois = new SerializationInputStream(fis);

			idCounter = ois.readInt();
			recipes = (Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>) ois.readObject();

			/*
			 * for (Entry<Integer, IAltarRecipe<?, ?>> en : recipes.entrySet())
			 * { en.getValue().SetID(en.getKey()); }
			 */

			ois.close();
			fis.close();
		}
		catch (ClassNotFoundException ex)
		{
			ex.printStackTrace();
		}
	}

	@Override
	public void Dispose()
	{
		SaveRecipes();
	}

	@Override
	public Integer AddIDedRecipe(IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> recipe)
	{
		if (!(recipe instanceof Serializable)) { return -1; }

		int ID = idCounter++;

		recipes.put(ID, recipe);

		return ID;
	}
	
	@Override
	public IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> GetRecipeByID(Integer id)
	{
		return this.recipes.get(id);
	}
}
