package an0nym8us.bukkit.magicCrafting.managers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffectType;

import an0nym8us.bukkit.magicCrafting.ConstantTranslation;
import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.menu.AdminMenu;
import an0nym8us.utils.menu.RomanNumeral;

@SuppressWarnings("deprecation")
public class LanguageManager
{
	YamlConfiguration config;

	public LanguageManager()
	{
		ExtractLanguageResources();

		LoadDefault();
		LoadConfigFile();

		ExchangeConstantItemStacks();
	}

	private void LoadDefaultTranslation()
	{
		HashMap<String, String> map = new HashMap<String, String>();

		map.put("yes", "Yes");
		map.put("no", "No");
		map.put("shapeless", ChatColor.RED + "Shapeless");
		map.put("shaped", ChatColor.GREEN + "Shaped");
		map.put("onlyPlayersCanExecute", ChatColor.RED + "Only players can execute this command!");
		map.put("noPermission", ChatColor.DARK_RED + "You have insufficient permissions to do that!");
		map.put("nameSet", ChatColor.GREEN + "Name has been set!");
		map.put("priceSet", ChatColor.GREEN + "Price has been set!");
		map.put("nameRemoved", ChatColor.BLUE + "Name has been removed!");
		map.put("priceRemoved", ChatColor.BLUE + "Price has been removed!");
		map.put("priceMustBePositive", ChatColor.RED + "Price must be positive!");
		map.put("onlyNumberAccepted", ChatColor.RED + "You can enter only number!");
		map.put("recipeAdded", ChatColor.GREEN + "Recipe has been added successfully!");
		map.put("tooFewParams", ChatColor.RED + "You have to enter more parameters!");
		map.put("noOwnership", ChatColor.DARK_RED + "You don't own it!");
		map.put("help.line0", ChatColor.GREEN + "This plugin implements two, completely new ways of brewing and crafting!");
		map.put("help.clickMe", "Click me to go to the plugin site!");
		map.put("help.line1", ChatColor.GREEN + "Commands:");
		map.put("help.line2", ChatColor.GRAY + "{0} - Shows this plenty of text");
		map.put("help.line3", ChatColor.GREEN + "{0} - The same as /magicCrafting");
		map.put("help.line4", ChatColor.GRAY + "{0} - Opens admin menu");
		map.put("help.line5", ChatColor.GREEN + "{0} - Destroys all structures");
		map.put("help.line6", ChatColor.GRAY + "{0} - Destroys Altars");
		map.put("help.line7", ChatColor.GREEN + "{0} - Destroys Brewing Cauldrons");
		map.put("help.line8", ChatColor.GRAY + "{0} - Creates Recipe Creator Structure; if it's been already created, then opens Recipe Creator menu");
		map.put("help.line9", ChatColor.GREEN + "{0} - Destroys current Altar-type structure (that one which you are staying at)");
		map.put("help.line10", ChatColor.GRAY + "{0} - Deletes recipe with specified ID");
		map.put("help.line11", ChatColor.GREEN + "{0} - Saves recipes");
		map.put("economy.paySummary", ChatColor.RED + "-{0}$");
		map.put("economy.notEnoughMoney", ChatColor.RED + "You have not enough money in your pocket! You need: {0}$");
		map.put("economy.notEnoughMoneyAtLeast", ChatColor.RED + "You have not enough money in your pocket! You need at least: {0}$");
		map.put("cauldron.create.noPermission", ChatColor.DARK_RED + "You have insufficient permissions to create Brewing Cauldron!");
		map.put("cauldron.firstLine", ChatColor.RED + "" + ChatColor.BOLD + "Brewing Cauldron");
		map.put("cauldron.secondLine", ChatColor.BLUE + "Fill your cauldron with water");
		map.put("cauldron.thirdLine", ChatColor.GREEN + "Then put your items into cauldron");
		map.put("cauldron.producing", ChatColor.BLUE + "Producing: {0}");
		map.put("cauldron.in", ChatColor.AQUA + "In: {0} seconds");
		map.put("cauldron.destroyed", ChatColor.GOLD + "Brewing Cauldron has been destroyed!");
		map.put("cauldron.maxReached", ChatColor.DARK_RED + "You cannot create more brewing cauldrons!!");
		map.put("potion.name", "{0}{1} of {2} {3}");
		map.put("potion.extended", "Extended");
		map.put("potion.splash", "Splash");
		map.put("altar.title", ChatColor.RED + "" + ChatColor.BOLD + "Bloody Altar");
		map.put("altar.level", ChatColor.BLUE + "Level {0}");
		map.put("altar.tooHighLevel", ChatColor.RED + "You can create maximally {1}-Level Bloody Altar!");
		map.put("altar.create.noPermission", ChatColor.DARK_RED + "You have insufficient permissions to create Bloody Altar!");
		map.put("altar.created", ChatColor.AQUA + "Altar has been created!");
		map.put("altar.maxReached", ChatColor.DARK_RED + "You cannot create more altars!");
		map.put("altar.noRecipePermissions", ChatColor.DARK_RED + "You have insufficient permissions to use this altar recipe!");
		map.put("altar.noAvailableRecipes", ChatColor.DARK_RED + "Could not find any available recipes!");
		map.put("altar.noItemsIn", ChatColor.RED + "No items on altar! Cannot begin crafting process.");
		map.put("altar.destroyed", ChatColor.BLUE + "Bloody Altar has been destroyed!");
		map.put("altar.notExists", ChatColor.DARK_RED + "Altar does not exist! You have to stand on altar to destroy it!");
		map.put("altar.incompletedCrafting", ChatColor.YELLOW + "You had not enough money to pay for all {0} craftings. Only {1} has been executed!");
		map.put("admin.altarsDisposed", ChatColor.GOLD + "Altars have been destroyed!");
		map.put("admin.cauldronsDisposed", ChatColor.GOLD + "Brewing cauldrons have been destroyed!");
		map.put("admin.allDisposed", ChatColor.GOLD + "Altars and brewing cauldrons have been destroyed!");
		map.put("admin.recipeDeleted", ChatColor.GREEN + "Recipe has been deleted!");
		map.put("admin.recipeCannotBeDeleted", ChatColor.RED + "Recipe cannot be deleted!");
		map.put("admin.recipeManagerIDTypeNotSupported", ChatColor.DARK_RED + "Current Recipe Manager uses unsupported recipe ID type!");
		map.put("admin.recipeManagerIDNotSupported", ChatColor.DARK_RED + "Current Recipe Manager does not support recipe IDs!");
		map.put("admin.recipesSaved", ChatColor.GREEN + "Recipes have been saved!");
		map.put("admin.recipesNotSaved", ChatColor.RED + "Recipes could not be saved!");
		map.put("admin.recipeStorageDoesntSupportSaving", ChatColor.RED + "Current recipe storage does not support saving!");
		map.put("DeprecatedRecipeCreationMenu.title", "Admin panel");
		map.put("DeprecatedRecipeCreationMenu.list.title", "Recipe list");
		map.put("DeprecatedRecipeCreationMenu.list.currentSite", ChatColor.GOLD + "Current Site: {0}");
		map.put("DeprecatedRecipeCreationMenu.list.modifier.valueDesc", ChatColor.GOLD + "Current value: {0}");
		map.put("DeprecatedRecipeCreationMenu.list.modifier.recipeNotFound", ChatColor.RED + "Recipe not found");
		map.put("DeprecatedRecipeCreationMenu.recipeModifier.title", ChatColor.DARK_BLUE + "Recipe Modifier");
		map.put("DeprecatedRecipeCreationMenu.recipeModifier.modifyingTitle", ChatColor.DARK_BLUE + "Recipe Modifier - Modifying Recipe");
		map.put("DeprecatedRecipeCreationMenu.recipeModifier.nullValueDesc", "Not set");
		map.put("recipeTemplate.title", ChatColor.GOLD + "Recipe - {0} x {1}");
		map.put("recipeTemplate.name", ChatColor.WHITE + "Name: " + ChatColor.BLUE + "{0}");
		map.put("recipeTemplate.price", ChatColor.WHITE + "Default Price: " + ChatColor.BLUE + "{0}");
		map.put("recipeTemplate.type", ChatColor.GREEN + "Type: {0}");
		map.put("recipeTemplate.checkOnlyType", ChatColor.RED + "Check only ingredient's type: " + ChatColor.GOLD + "{0}");
		map.put("recipeTemplate.ignoreDurability", ChatColor.RED + "Does ignore ingrendient's durability: " + ChatColor.GOLD + "{0}");
		map.put("recipeTemplate.ingredients", ChatColor.BLUE + "Ingredients: ");
		map.put("recipeTemplate.ingredientData", ChatColor.GREEN + "{0} x {1}");
		map.put("recipeTemplate.tooManyIngredients", ChatColor.DARK_GRAY + "" + ChatColor.ITALIC + "Too many ingredients...");
		map.put("recipeCreatorStructure.title", ChatColor.AQUA + "" + ChatColor.BOLD + "Recipe Creator Structure");
		map.put("recipeCreatorStructure.created", ChatColor.LIGHT_PURPLE + "Recipe Creator Structure created successfully!");
		map.put("recipeCreatorStructure.structureAlreadyExists", ChatColor.RED + "Structure is already created!");
		map.put("recipeCreatorStructure.onlyOneRecipeCreatorStructureAllowed", ChatColor.RED + "Only one Recipe Creator Structure per player is allowed!");
		map.put("recipeCreatorStructure.incompleteRecipe", ChatColor.RED + "Recipe is missing some parts!");
		map.put("recipeCreatorStructure.invalidAltar", ChatColor.RED + "Cannot create Recipe Creator Structure - invalid altar!");
		map.put("recipeCreatorStructure.enterHere", ChatColor.GREEN + "Enter new value of chosen variable here.");
		map.put("recipeCreatorStructure.notExists", ChatColor.DARK_RED + "Recipe Creator Structure does not exist!");
		map.put("recipeCreatorStructure.destroyed", ChatColor.BLUE + "Recipe Creator Structure has been destroyed!");
		map.put("recipeCreatorStructure.noResultItem", ChatColor.RED + "Result item is missing!");
		map.put("recipeCreatorStructure.noIngredients", ChatColor.RED + "Ingredient items are missing!");
		map.put("recipeCreatorStructure.recipeAdded", ChatColor.GREEN + "Recipe added!");
		map.put("recipeCreatorStructure.recipeModified", ChatColor.BLUE + "Recipe modified!");
		map.put("recipeCreatorStructure.modifiedRecipeDeleted", ChatColor.GOLD + "Recipe has been deleted by another player during modifying by you");
		map.put("recipeCreatorStructure.couldntAddRecipe", ChatColor.DARK_RED + "Couldn't add recipe; cannot access recipes.yml file!");
		map.put("recipeCreatorStructure.tooSmallStructure", ChatColor.RED + "Recipe Creator Structure is too small for modifying chosen recipe!");

		for (Entry<String, String> en : map.entrySet())
		{
			config.addDefault(en.getKey(), en.getValue().replace('', '&'));
		}
	}

	private void LoadConstantItemStacks()
	{
		Field[] fields = AdminMenu.class.getDeclaredFields();

		for (Field f : fields)
		{
			f.setAccessible(true);

			if (f.getType() == ItemStack.class && f.isAnnotationPresent(ConstantTranslation.class))
			{
				ConstantTranslation a = f.getAnnotation(ConstantTranslation.class);

				config.addDefault(a.nameCode() + ".name", a.defaultName().replace('', '&'));

				for (int i = 0; i < a.desc().length; i++)
				{
					config.addDefault(a.nameCode() + ".desc" + Integer.toString(i), a.desc()[i].replace('', '&'));
				}
			}
		}
	}

	private void ExchangeConstantItemStacks()
	{
		Field[] fields = AdminMenu.class.getDeclaredFields();

		for (Field f : fields)
		{
			f.setAccessible(true);

			if (f.getType() == ItemStack.class && f.isAnnotationPresent(ConstantTranslation.class))
			{
				ConstantTranslation a = f.getAnnotation(ConstantTranslation.class);

				try
				{
					List<String> lore = new ArrayList<String>();

					for (int i = 0; config.contains(a.nameCode() + ".desc" + Integer.toString(i)); i++)
					{
						lore.add(config.getString(a.nameCode() + ".desc" + Integer.toString(i)).replace('&', ''));
					}

					f.set(null, new ISBuilder((ItemStack) f.get(null)).SetName(this.GetString(a.nameCode() + ".name").replace('&', '')).SetLore(lore).GetResult());
				}
				catch (IllegalArgumentException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				catch (IllegalAccessException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}

	private void LoadDefault()
	{
		config = new YamlConfiguration();

		for (Material mat : Material.values())
		{
			String[] ar = mat.name().split("\\_");

			StringBuilder sb = new StringBuilder();

			for (int i = 0; i < ar.length - 1; i++)
			{
				ar[i] = ar[i].toLowerCase();
				ar[i] = Character.toUpperCase(ar[i].charAt(0)) + ar[i].substring(1, ar[i].length());

				sb.append(ar[i]);
				sb.append(' ');
			}

			ar[ar.length - 1] = ar[ar.length - 1].toLowerCase();
			ar[ar.length - 1] = Character.toUpperCase(ar[ar.length - 1].charAt(0)) + ar[ar.length - 1].substring(1, ar[ar.length - 1].length());

			sb.append(ar[ar.length - 1]);

			config.addDefault("material." + mat.name(), sb.toString());
		}

		config.addDefault("material." + Material.INK_SACK.name() + "~1", "Rose Red");
		config.addDefault("material." + Material.INK_SACK.name() + "~14", "Orange Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~11", "Dandelion Yellow");
		config.addDefault("material." + Material.INK_SACK.name() + "~2", "Cactus Green");
		config.addDefault("material." + Material.INK_SACK.name() + "~4", "Lapis Lazuli");
		config.addDefault("material." + Material.INK_SACK.name() + "~12", "Light Blue Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~13", "Magenta Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~9", "Pink Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~15", "Bone Meal");
		config.addDefault("material." + Material.INK_SACK.name() + "~7", "Light Gray Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~3", "Cocoa Beans");
		config.addDefault("material." + Material.INK_SACK.name() + "~6", "Cyan Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~5", "Purple Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~8", "Gray Dye");
		config.addDefault("material." + Material.INK_SACK.name() + "~10", "Lime Dye");

		config.addDefault("potionEffectType.ABSORPTION", "Absorption");
		config.addDefault("potionEffectType.BLINDNESS", "Blindness");
		config.addDefault("potionEffectType.CONFUSION", "Nausea");
		config.addDefault("potionEffectType.DAMAGE_RESISTANCE", "Resistance");
		config.addDefault("potionEffectType.FAST_DIGGING", "Haste");
		config.addDefault("potionEffectType.FIRE_RESISTANCE", "Fire Resistance");
		config.addDefault("potionEffectType.GLOWING", "Glowing");
		config.addDefault("potionEffectType.HARM", "Harming");
		config.addDefault("potionEffectType.HEAL", "Healing");
		config.addDefault("potionEffectType.HEALTH_BOOST", "Health Boost");
		config.addDefault("potionEffectType.HUNGER", "Hunger");
		config.addDefault("potionEffectType.INCREASE_DAMAGE", "Strength");
		config.addDefault("potionEffectType.INVISIBILITY", "Invisibility");
		config.addDefault("potionEffectType.JUMP", "Jumping");
		config.addDefault("potionEffectType.NIGHT_VISION", "Night Vision");
		config.addDefault("potionEffectType.POISON", "Poison");
		config.addDefault("potionEffectType.REGENERATION", "Regeneration");
		config.addDefault("potionEffectType.SATURATION", "Saturation");
		config.addDefault("potionEffectType.SLOW", "Slowness");
		config.addDefault("potionEffectType.SLOW_DIGGING", "Mining fatigue");
		config.addDefault("potionEffectType.SPEED", "Speed");
		config.addDefault("potionEffectType.WATER_BREATHING", "Water Breathing");
		config.addDefault("potionEffectType.WITHER", "Wither");

		LoadDefaultTranslation();
		LoadConstantItemStacks();

		config.options().copyDefaults(true);
	}

	private boolean LoadConfigFile()
	{
		File file = Main.GetInstance().GetConfigManager().GetLanguageFile();

		if (!file.exists())
		{
			try
			{
				Bukkit.getLogger().info(Main.GetInstance().GetConfigManager().GetLanguagePath() + " - not found; creating and loading language configuration into");

				new File(Main.GetInstance().getDataFolder(), "languages").mkdirs();

				file.createNewFile();

				config.save(file);

				return true;
			}
			catch (IOException e)
			{
				e.printStackTrace();

				return false;
			}
		}

		try
		{
			config.load(file);

			config.save(file);
		}
		catch (IOException | InvalidConfigurationException e)
		{
			e.printStackTrace();

			return false;
		}

		return true;
	}

	private void ExtractLanguageResources()
	{
		final String path = "languages";
		final File jarFile = new File(getClass().getProtectionDomain().getCodeSource().getLocation().getPath());

		new File(Main.GetInstance().getDataFolder(), path).mkdirs();
		
		if (jarFile.isFile())
		{
			JarFile jar;
			try
			{
				jar = new JarFile(jarFile);
			}
			catch (IOException e)
			{
				Bukkit.getLogger().warning("Cannot load default language resources.");

				return;
			}

			final Enumeration<JarEntry> entries = jar.entries(); // gives ALL
																	// entries
																	// in jar
			while (entries.hasMoreElements())
			{
				JarEntry je = entries.nextElement();
				final String name = je.getName();

				if (name.startsWith(path + "/"))
				{
					File f = new File(Main.GetInstance().getDataFolder(), name);

					if (!f.exists())
					{
						try
						{
							f.createNewFile();

							FileOutputStream fos = new FileOutputStream(f);

							InputStream is = jar.getInputStream(je);							
							byte[] data = new byte[is.available()];
							is.read(data);
							is.close();
							
							fos.write(data);

							fos.close();
						}
						catch (IOException e)
						{
							Bukkit.getLogger().warning("Couldn't create and load file: " + name + ".");

							continue;
						}
					}
				}
			}

			try
			{
				jar.close();
			}
			catch (IOException e)
			{
				return;
			}
		}
	}

	public boolean ContainsString(String code)
	{
		return config.contains(code);
	}

	public String GetString(String code)
	{
		if (config.contains(code)) { return config.getString(code).replace('&', ''); }

		return null;
	}

	public String GetFormattedString(String code, String... params)
	{
		if (config.contains(code))
		{
			String res = config.getString(code);

			for (int i = 0; i < params.length; i++)
			{
				if (params[i] != null)
				{
					res = res.replace("{" + i + "}", params[i]);
				}
			}

			return res.replace('&', '');
		}

		return null;
	}

	public static String GetText(String code)
	{
		return Main.GetInstance().GetLanguageManager().GetString(code);
	}

	public static String GetFormattedText(String code, String... params)
	{
		return Main.GetInstance().GetLanguageManager().GetFormattedString(code, params);
	}

	public String GetItemName(ItemStack is)
	{
		if (is.hasItemMeta() && is.getItemMeta().hasDisplayName()) { return is.getItemMeta().getDisplayName(); }

		if (!is.getType().equals(Material.POTION)) { return GetItemName(is.getType(), is.getDurability()); }

		String param0 = "";
		String param1 = GetItemName(is.getType(), is.getDurability());

		Potion p = Potion.fromItemStack(is);

		if (p.isSplash())
		{
			param0 += GetText("potion.splash") + " ";
		}

		if (p.hasExtendedDuration())
		{
			param0 += GetText("potion.extended") + " ";
		}

		if (p.getType() != null && p.getType().getEffectType() != null)
		{
			return GetFormattedText("potion.name", param0, param1, GetPotionEffectName(p.getType().getEffectType()), new RomanNumeral(p.getLevel()).toString());
		}
		else
		{
			return param0 + param1;
		}
	}

	public String GetPotionEffectName(PotionEffectType effect)
	{
		return ContainsString("potionEffectType." + effect.getName()) ? GetString("potionEffectType." + effect.getName())
																																																																																		: effect.getName();
	}

	public String GetItemName(Material mat, int durability)
	{
		if (config.contains("material." + mat.name() + "~" + Integer.toString(durability))) { return config.getString("material." + mat.name() + "~" + Integer.toString(durability)); }

		return config.getString("material." + mat.name());
	}

	public String GetItemName(Material mat)
	{
		return config.getString("material." + mat.name());
	}

	public String GetEffectParamName(String paramID)
	{
		return config.getString("effectParameter." + paramID);
	}

	public static void SendMessage(UUID uuid, String msg)
	{
		Player player = Bukkit.getPlayer(uuid);

		if (player != null)
		{
			player.sendMessage(msg);
		}
	}
}
