package an0nym8us.bukkit.magicCrafting.managers;

import java.util.List;

import an0nym8us.bukkit.magicCrafting.IDisposable;
import an0nym8us.bukkit.magicCrafting.altar.IRecipe;

public interface IRecipeManager<I, O> extends IDisposable, Iterable<IRecipe<? super I, ? extends O>>
{
	public boolean AddRecipe(IRecipe<? super I, ? extends O> recipe);
	
	public boolean DeleteRecipe(IRecipe<? super I, ? extends O> recipe);
	
	public IRecipe<? super I, ? extends O> GetFirstMatchingRecipe(I input);

	public List<IRecipe<? super I, ? extends O>> GetMatchingRecipes(I input);
	
	public List<IRecipe<? super I, ? extends O>> GetRecipes();
	
	public IRecipe<? super I, ? extends O> GetRecipe(int index);
	
	public int GetRecipeAmount();
}
