package an0nym8us.bukkit.magicCrafting.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.bukkit.Bukkit;

import com.google.common.io.Files;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.SerializationInputStream;
import an0nym8us.bukkit.magicCrafting.SerializationOutputStream;
import an0nym8us.bukkit.magicCrafting.altar.IRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeInput;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeOutput;

public class FileRecipeManager extends PreloadedRecipeManager
{
	int savingTask = -1;

	public FileRecipeManager(boolean loadMinecraftRecipes)
	{
		super(loadMinecraftRecipes);

		LoadRecipes();

		savingTask = Bukkit.getScheduler().runTaskTimerAsynchronously(Main.GetInstance(), new Runnable()
		{
			@Override
			public void run()
			{
				SaveRecipes();
			}
		}, Main.GetInstance().GetConfigManager().getFileSavingPeriod(),
				Main.GetInstance().GetConfigManager().getFileSavingPeriod()).getTaskId();
	}
	
	@Override
	public void Dispose()
	{
		Bukkit.getScheduler().cancelTask(savingTask);

		SaveRecipes();
	}

	public boolean LoadRecipes()
	{
		File file = new File(Main.GetInstance().getDataFolder(), "recipes.bin");

		if (!file.exists())
		{
			try
			{
				file.createNewFile();

				recipes = new HashMap<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>();

				SerializeToFile(file, idCounter, recipes);

				return true;
			}
			catch (IOException e)
			{
				return false;
			}
		}

		try
		{
			DeserializeFromFile(file);
		}
		catch (IOException ex)
		{
			recipes = null;
		}

		try
		{
			if (recipes == null)
			{
				Files.copy(file, new File(Main.GetInstance().getDataFolder(),
						"recipesBackup-" + new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date()) + ".bin"));

				recipes = new HashMap<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>();

				SerializeToFile(file, idCounter, recipes);

				Bukkit.getLogger().warning("Recipe file is corrupted! Backupping it and creating a new one!");
			}
		}
		catch (IOException e)
		{
			Bukkit.getLogger().severe("Could not backup corrupted recipe.bin file! Disabling plugin!");

			e.printStackTrace();

			Bukkit.getPluginManager().disablePlugin(Main.GetInstance());

			return false;
		}

		return true;
	}

	public boolean SaveRecipes()
	{
		File file = new File(Main.GetInstance().getDataFolder(), "recipes.bin");

		if (!file.exists())
		{
			try
			{
				file.createNewFile();
			}
			catch (IOException e)
			{
				return false;
			}
		}

		try
		{
			synchronized (recipes)
			{
				SerializeToFile(file, idCounter, recipes);
			}

			return true;
		}
		catch (IOException e)
		{
			Bukkit.getLogger().severe("Could not save recipes!");

			e.printStackTrace();
		}

		return false;
	}
	
	protected static void SerializeToFile(File file, int idCounter, Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> list)
			throws IOException
	{
		FileOutputStream fos = new FileOutputStream(file);
		SerializationOutputStream oos = new SerializationOutputStream(fos);

		oos.writeInt(idCounter);
		oos.writeObject(list);

		oos.close();
		fos.close();
	}

	@SuppressWarnings("unchecked")
	protected void DeserializeFromFile(File file) throws IOException
	{
		FileInputStream fis = null;
		SerializationInputStream ois = null;
		
		try
		{
			fis = new FileInputStream(file);
			ois = new SerializationInputStream(fis);

			idCounter = ois.readInt();
			recipes = (Map<Integer, IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>>) ois.readObject();

			ois.close();
			fis.close();
		}
		catch (ClassNotFoundException ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			if(ois != null)
			{
				ois.close();
			}
			
			if(fis != null)
			{
				fis.close();
			}
		}
	}
}