package an0nym8us.bukkit.magicCrafting.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;
import java.util.Set;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.PermissionAttachmentInfo;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.SerializationProvider;
import an0nym8us.bukkit.magicCrafting.altar.ArmorDyeAltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.BookCloneAltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.INameable;
import an0nym8us.bukkit.magicCrafting.altar.IRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeInput;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeOutput;
import an0nym8us.bukkit.magicCrafting.altar.MapCloneAltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.RepairAltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ShapedAltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ShapelessAltarRecipe;

public class DefaultRecipeManager<I extends ItemAltarRecipeInput> implements IRecipeManager<I, ItemAltarRecipeOutput>
{
	List<IRecipe<? super I, ? extends ItemAltarRecipeOutput>> defaultRecipes;
	
	public DefaultRecipeManager(boolean loadMinecraftRecipes)
	{
		defaultRecipes = new ArrayList<IRecipe<? super I, ? extends ItemAltarRecipeOutput>>();

		if (loadMinecraftRecipes)
		{
			Iterator<Recipe> iterator = Bukkit.recipeIterator();

			Recipe r = null;
			
			defaultRecipes.add(new BookCloneAltarRecipe());
			defaultRecipes.add(new ArmorDyeAltarRecipe());
			defaultRecipes.add(new MapCloneAltarRecipe());
			// mcRecipes.add(new MapExtendAltarRecipe());
			defaultRecipes.add(new RepairAltarRecipe());

			while (iterator.hasNext())
			{
				r = iterator.next();

				if (r.getResult().getAmount() == 0)
				{
					continue;
				}

				if (r instanceof ShapedRecipe)
				{
					ShapedRecipe sp = (ShapedRecipe) r;

					boolean ignoreDur = false;

					for (Entry<Character, ItemStack> en : sp.getIngredientMap().entrySet())
					{
						if (en.getValue() != null
								&& (en.getValue().getDurability() == 32767 || en.getValue().getDurability() == -1))
						{
							ignoreDur = true;
							break;
						}
					}

					defaultRecipes.add((new ShapedAltarRecipe(sp.getResult(), true, ignoreDur, sp.getIngredientMap(), ShapedAltarRecipe.StringToChar(sp.getShape()))));
				}
				else if (r instanceof ShapelessRecipe)
				{
					ShapelessRecipe sp = (ShapelessRecipe) r;

					boolean ignoreDur = false;

					for (ItemStack is : sp.getIngredientList())
					{
						if (is != null && (is.getDurability() == 32767 || is.getDurability() == -1))
						{
							ignoreDur = true;
							break;
						}
					}

					defaultRecipes.add(new ShapelessAltarRecipe(sp.getResult(), sp.getIngredientList().toArray(new ItemStack[sp.getIngredientList().size()]),true, ignoreDur));
				}
			}
		}
	}

	public static boolean CanAccess(INameable ar, Permissible p)
	{
		return p == null ? true
				: (ar.HasName() ? p.hasPermission("magicAspect.crafting.recipe." + ar.GetName())
						|| p.hasPermission("magicAspect.crafting.recipe.*") : true);
	}

	public static boolean CheckPermissions(UUID uuid, INameable ar)
	{
		if (!Main.GetInstance().GetConfigManager().isEnableNamedRecipePermissions() || !ar.HasName()) { return true; }

		if (Bukkit.getPlayer(uuid) == null) { return false; }

		Set<PermissionAttachmentInfo> permissions = Bukkit.getPlayer(uuid).getEffectivePermissions();

		for (PermissionAttachmentInfo pai : permissions)
		{
			if (pai.getPermission().equals("magicaspect.crafting.recipe.*") || pai.getPermission()
					.equals("magicaspect.crafting.recipe." + ar.GetName().toLowerCase())) { return pai.getValue(); }
		}

		return false;
	}

	public IRecipe<? super I, ? extends ItemAltarRecipeOutput> GetFirstMatchingRecipe(I input)
	{
		for (IRecipe<? super I, ? extends ItemAltarRecipeOutput> ar : defaultRecipes)
		{
			try
			{
				if (ar.DoesMatch(input)) { return ar; }
			}
			catch (ClassCastException ex)
			{
				continue;
			}
		}

		return null;
	}

	public List<IRecipe<? super I, ? extends ItemAltarRecipeOutput>> GetMatchingRecipes(I input)
	{
		List<IRecipe<? super I, ? extends ItemAltarRecipeOutput>> res = new ArrayList<IRecipe<? super I, ? extends ItemAltarRecipeOutput>>();

		for (IRecipe<? super I, ? extends ItemAltarRecipeOutput> ar : defaultRecipes)
		{
			try
			{
				if (ar.DoesMatch(input))
				{
					res.add(ar);
				}
			}
			catch (ClassCastException ex)
			{
				continue;
			}
		}

		return res;
	}

	public List<IRecipe<? super I, ? extends ItemAltarRecipeOutput>> GetRecipes()
	{
		return defaultRecipes;
	}

	public boolean AddRecipe(IRecipe<? super I, ? extends ItemAltarRecipeOutput> ar)
	{
		return defaultRecipes.add(ar);
	}

	public boolean DeleteRecipe(IRecipe<? super I, ? extends ItemAltarRecipeOutput> ar)
	{
		return defaultRecipes.remove(ar);
	}

	public boolean ReplaceRecipe(IRecipe<? super I, ? extends ItemAltarRecipeOutput> oldRecipe, IRecipe<? super I, ? extends ItemAltarRecipeOutput> newRecipe)
	{
		int index = defaultRecipes.indexOf(oldRecipe);

		if (defaultRecipes.indexOf(oldRecipe) == -1) { return false; }

		defaultRecipes.set(index, newRecipe);

		return true;
	}

	public int GetRecipeAmount()
	{
		return defaultRecipes.size();
	}

	protected static byte[] Serialize(List<IRecipe<?, ?>> list) throws IOException
	{
		return SerializationProvider.Serialize(list);
	}

	@SuppressWarnings("unchecked")
	protected static List<IRecipe<?, ?>> Deserialize(byte[] data) throws IOException, ClassNotFoundException
	{
		return (List<IRecipe<?, ?>>) SerializationProvider.Deserialize(data);
	}

	@Override
	public void Dispose()
	{
		defaultRecipes.clear();
	}

	@Override
	public boolean IsDisposed()
	{
		return defaultRecipes.isEmpty();
	}

	@Override
	public Iterator<IRecipe<? super I, ? extends ItemAltarRecipeOutput>> iterator()
	{
		return defaultRecipes.iterator();
	}

	@Override
	public IRecipe<? super I, ? extends ItemAltarRecipeOutput> GetRecipe(int index)
	{
		return defaultRecipes.get(index);
	}
}
